/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.network.toclient;

import com.hbm.HBMsNTMClient;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record InformPlayerPacket(boolean fancy, String message, Component component, int id, int millis) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<InformPlayerPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"hbmsntm", (String)"inform_player"));
    public static final StreamCodec<RegistryFriendlyByteBuf, InformPlayerPacket> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, InformPlayerPacket>(){

        public InformPlayerPacket decode(RegistryFriendlyByteBuf buf) {
            int id = buf.readInt();
            int millis = buf.readInt();
            boolean fancy = buf.readBoolean();
            if (!fancy) {
                String msg = buf.readUtf();
                return new InformPlayerPacket(false, msg, null, id, millis);
            }
            Component comp = (Component)ComponentSerialization.STREAM_CODEC.decode((Object)buf);
            return new InformPlayerPacket(true, null, comp, id, millis);
        }

        public void encode(RegistryFriendlyByteBuf buf, InformPlayerPacket packet) {
            buf.writeInt(packet.id);
            buf.writeInt(packet.millis);
            buf.writeBoolean(packet.fancy);
            if (!packet.fancy) {
                buf.writeUtf(packet.message);
            } else {
                ComponentSerialization.STREAM_CODEC.encode((Object)buf, (Object)packet.component);
            }
        }
    };

    public static void handleClient(InformPlayerPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            try {
                if (packet.fancy()) {
                    HBMsNTMClient.displayTooltip(packet.component(), packet.millis(), packet.id());
                } else {
                    HBMsNTMClient.displayTooltip((Component)Component.literal((String)packet.message()), packet.millis(), packet.id());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

