/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.network.toserver;

import com.hbm.extprop.LivingProperties;
import com.hbm.network.toclient.SendRadPacket;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record GetRadPacket(UUID targetId) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<GetRadPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"hbmsntm", (String)"get_rad"));
    public static final StreamCodec<FriendlyByteBuf, GetRadPacket> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, GetRadPacket>(){

        public GetRadPacket decode(FriendlyByteBuf buf) {
            return new GetRadPacket(buf.readUUID());
        }

        public void encode(FriendlyByteBuf buf, GetRadPacket packet) {
            buf.writeUUID(packet.targetId);
        }
    };

    public static void handleServer(GetRadPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer sender = (ServerPlayer)patt0$temp;
            MinecraftServer server = sender.server;
            UUID target = packet.targetId();
            for (ServerLevel level : server.getAllLevels()) {
                Entity entity = level.getEntity(target);
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity living = (LivingEntity)entity;
                float rad = LivingProperties.getRadiation(living);
                PacketDistributor.sendToPlayer((ServerPlayer)sender, (CustomPacketPayload)new SendRadPacket(rad), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

