/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.network.toserver;

import com.hbm.extprop.PlayerProperties;
import com.hbm.handler.Keybinds;
import com.hbm.items.IKeybindReceiver;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record KeybindReceiver(Keybinds.EnumKeybind keybind, boolean state, boolean property) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<KeybindReceiver> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"hbmsntm", (String)"keybind"));
    public static final StreamCodec<FriendlyByteBuf, KeybindReceiver> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, KeybindReceiver>(){

        public KeybindReceiver decode(FriendlyByteBuf buf) {
            Keybinds.EnumKeybind key = (Keybinds.EnumKeybind)buf.readEnum(Keybinds.EnumKeybind.class);
            boolean state = buf.readBoolean();
            boolean property = buf.readBoolean();
            return new KeybindReceiver(key, state, property);
        }

        public void encode(FriendlyByteBuf buf, KeybindReceiver packet) {
            buf.writeEnum((Enum)packet.keybind);
            buf.writeBoolean(packet.state);
            buf.writeBoolean(packet.property);
        }
    };

    public static void handleServer(KeybindReceiver packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)patt0$temp;
            if (packet.property) {
                PlayerProperties props = PlayerProperties.getData((Player)player);
                props.setKeyPressed(packet.keybind(), packet.state());
            }
            if (!packet.property) {
                IKeybindReceiver receiver;
                ItemStack off;
                Item patt2$temp;
                IKeybindReceiver receiver2;
                ItemStack stack = player.getMainHandItem();
                Item patt1$temp = stack.getItem();
                if (patt1$temp instanceof IKeybindReceiver && (receiver2 = (IKeybindReceiver)patt1$temp).canHandleKeybind((Player)player, stack, packet.keybind())) {
                    receiver2.handleKeybind((Player)player, stack, packet.keybind(), packet.state());
                }
                if ((patt2$temp = (off = player.getOffhandItem()).getItem()) instanceof IKeybindReceiver && (receiver = (IKeybindReceiver)patt2$temp).canHandleKeybind((Player)player, off, packet.keybind())) {
                    receiver.handleKeybind((Player)player, off, packet.keybind(), packet.state());
                }
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

