/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.particle;

import com.hbm.particle.IParticleRenderType;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Random;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;

public class ParticleAmatFlash
extends TextureSheetParticle {
    public ParticleAmatFlash(ClientLevel level, double x, double y, double z, float scale) {
        super(level, x, y, z);
        this.lifetime = 10;
        this.quadSize = scale;
    }

    private static float[] rotX(float x, float y, float z, float deg) {
        double r = Math.toRadians(deg);
        double c = Math.cos(r);
        double s = Math.sin(r);
        return new float[]{x, (float)((double)y * c - (double)z * s), (float)((double)y * s + (double)z * c)};
    }

    private static float[] rotY(float x, float y, float z, float deg) {
        double r = Math.toRadians(deg);
        double c = Math.cos(r);
        double s = Math.sin(r);
        return new float[]{(float)((double)x * c + (double)z * s), y, (float)((double)(-x) * s + (double)z * c)};
    }

    private static float[] rotZ(float x, float y, float z, float deg) {
        double r = Math.toRadians(deg);
        double c = Math.cos(r);
        double s = Math.sin(r);
        return new float[]{(float)((double)x * c - (double)y * s), (float)((double)x * s + (double)y * c), z};
    }

    public void render(VertexConsumer consumer, Camera camera, float partialTicks) {
        PoseStack poseStack = new PoseStack();
        double camX = camera.getPosition().x;
        double camY = camera.getPosition().y;
        double camZ = camera.getPosition().z;
        float px = (float)(this.xo + (this.x - this.xo) * (double)partialTicks - camX);
        float py = (float)(this.yo + (this.y - this.yo) * (double)partialTicks - camY);
        float pz = (float)(this.zo + (this.z - this.zo) * (double)partialTicks - camZ);
        poseStack.pushPose();
        poseStack.translate(px, py, pz);
        float globalScale = 0.2f * this.quadSize;
        poseStack.scale(globalScale, globalScale, globalScale);
        float intensity = ((float)this.age + partialTicks) / (float)this.lifetime;
        float inverse = 1.0f - intensity;
        PoseStack.Pose pose = poseStack.last();
        Random random = new Random(432L);
        float localScale = 0.5f;
        float startR = 0.4f;
        float startG = 0.5f;
        float startB = 1.0f;
        float endR = 1.0f;
        float endG = 1.0f;
        float endB = 1.0f;
        float r = startR + (endR - startR) * intensity;
        float g = startG + (endG - startG) * intensity;
        float b = startB + (endB - startB) * intensity;
        int centerAlpha = Math.max(0, Math.min(255, (int)(inverse * 255.0f)));
        for (int i = 0; i < 100; ++i) {
            float vert1 = (random.nextFloat() * 20.0f + 5.0f + 10.0f) * (intensity * localScale);
            float vert2 = (random.nextFloat() * 2.0f + 1.0f + 2.0f) * (intensity * localScale);
            float x1 = -0.866f * vert2;
            float y1 = vert1;
            float z1 = -0.5f * vert2;
            float x2 = 0.866f * vert2;
            float y2 = vert1;
            float z2 = -0.5f * vert2;
            float x3 = 0.0f;
            float y3 = vert1;
            float z3 = 1.0f * vert2;
            float a1 = random.nextFloat() * 360.0f;
            float a2 = random.nextFloat() * 360.0f;
            float a3 = random.nextFloat() * 360.0f;
            float a4 = random.nextFloat() * 360.0f;
            float a5 = random.nextFloat() * 360.0f;
            float[] p1 = ParticleAmatFlash.rotY(ParticleAmatFlash.rotX(x1, y1, z1, a1)[0], ParticleAmatFlash.rotX(x1, y1, z1, a1)[1], ParticleAmatFlash.rotX(x1, y1, z1, a1)[2], a2);
            p1 = ParticleAmatFlash.rotZ(p1[0], p1[1], p1[2], a3);
            p1 = ParticleAmatFlash.rotX(p1[0], p1[1], p1[2], a4);
            p1 = ParticleAmatFlash.rotY(p1[0], p1[1], p1[2], a5);
            float[] p2 = ParticleAmatFlash.rotY(ParticleAmatFlash.rotX(x2, y2, z2, a1)[0], ParticleAmatFlash.rotX(x2, y2, z2, a1)[1], ParticleAmatFlash.rotX(x2, y2, z2, a1)[2], a2);
            p2 = ParticleAmatFlash.rotZ(p2[0], p2[1], p2[2], a3);
            p2 = ParticleAmatFlash.rotX(p2[0], p2[1], p2[2], a4);
            p2 = ParticleAmatFlash.rotY(p2[0], p2[1], p2[2], a5);
            float[] p3 = ParticleAmatFlash.rotY(ParticleAmatFlash.rotX(x3, y3, z3, a1)[0], ParticleAmatFlash.rotX(x3, y3, z3, a1)[1], ParticleAmatFlash.rotX(x3, y3, z3, a1)[2], a2);
            p3 = ParticleAmatFlash.rotZ(p3[0], p3[1], p3[2], a3);
            p3 = ParticleAmatFlash.rotX(p3[0], p3[1], p3[2], a4);
            p3 = ParticleAmatFlash.rotY(p3[0], p3[1], p3[2], a5);
            consumer.addVertex(pose.pose(), 0.0f, 0.0f, 0.0f).setColor(r, g, b, (float)centerAlpha / 255.0f).setNormal(pose, 0.0f, 1.0f, 0.0f);
            consumer.addVertex(pose.pose(), p1[0], p1[1], p1[2]).setColor(r, g, b, 0.0f).setNormal(pose, 0.0f, 1.0f, 0.0f);
            consumer.addVertex(pose.pose(), p2[0], p2[1], p2[2]).setColor(r, g, b, 0.0f).setNormal(pose, 0.0f, 1.0f, 0.0f);
            consumer.addVertex(pose.pose(), 0.0f, 0.0f, 0.0f).setColor(r, g, b, (float)centerAlpha / 255.0f).setNormal(pose, 0.0f, 1.0f, 0.0f);
            consumer.addVertex(pose.pose(), p2[0], p2[1], p2[2]).setColor(r, g, b, 0.0f).setNormal(pose, 0.0f, 1.0f, 0.0f);
            consumer.addVertex(pose.pose(), p3[0], p3[1], p3[2]).setColor(r, g, b, 0.0f).setNormal(pose, 0.0f, 1.0f, 0.0f);
            consumer.addVertex(pose.pose(), 0.0f, 0.0f, 0.0f).setColor(r, g, b, (float)centerAlpha / 255.0f).setNormal(pose, 0.0f, 1.0f, 0.0f);
            consumer.addVertex(pose.pose(), p3[0], p3[1], p3[2]).setColor(r, g, b, 0.0f).setNormal(pose, 0.0f, 1.0f, 0.0f);
            consumer.addVertex(pose.pose(), p1[0], p1[1], p1[2]).setColor(r, g, b, 0.0f).setNormal(pose, 0.0f, 1.0f, 0.0f);
        }
        poseStack.popPose();
    }

    public ParticleRenderType getRenderType() {
        return IParticleRenderType.AMAT_FLASH;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        public Particle createParticle(SimpleParticleType type, ClientLevel world, double x, double y, double z, double dx, double dy, double dz) {
            return new ParticleAmatFlash(world, x, y, z, 1.0f);
        }
    }
}

