/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.particle;

import com.hbm.particle.ModParticles;
import com.hbm.particle.ParticleRotating;
import com.hbm.util.Vec3NT;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ParticleAshes
extends ParticleRotating {
    public ParticleAshes(ClientLevel level, double x, double y, double z, float scale) {
        super(level, x, y, z);
        this.setSpriteFromAge(ModParticles.ROCKET_FLAME_SPRITES);
        this.lifetime = 1200 + this.random.nextInt(20);
        this.quadSize = scale * 0.9f + this.random.nextFloat() * 0.2f;
        this.gravity = 0.01f;
        this.gCol = this.bCol = this.random.nextFloat() * 0.1f + 0.1f;
        this.rCol = this.bCol;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        ++this.age;
        if (this.age >= this.lifetime) {
            this.remove();
        }
        this.yd -= (double)this.gravity;
        this.oRoll = this.roll;
        if (!this.onGround) {
            this.roll += (float)(2.0 * ((double)(((Object)((Object)this)).hashCode() % 2) - 0.5));
        }
        this.xd *= 0.95;
        this.yd *= 0.99;
        this.zd *= 0.95;
        boolean wasOnGround = this.onGround;
        this.move(this.xd, this.yd, this.zd);
        if (!wasOnGround && this.onGround) {
            this.roll = this.random.nextFloat() * 360.0f;
        }
        if (((Object)((Object)this)).hashCode() % 5 == 0 && this.onGround && this.random.nextInt(15) == 0) {
            this.level.addParticle((ParticleOptions)ParticleTypes.SMOKE, this.x, this.y + 0.125, this.z, 0.0, 0.05, 0.0);
        }
    }

    public void render(VertexConsumer consumer, Camera camera, float partialTicks) {
        Vec3 cameraPosition = camera.getPosition();
        float timeLeft = (float)this.lifetime - ((float)this.age + partialTicks);
        Vector3f up = new Vector3f((Vector3fc)camera.getUpVector());
        Vector3f left = new Vector3f((Vector3fc)camera.getLeftVector());
        this.alpha = timeLeft < 40.0f ? timeLeft / 40.0f : 1.0f;
        if (this.onGround) {
            float pX = (float)(Mth.lerp((double)partialTicks, (double)this.xo, (double)this.x) - cameraPosition.x);
            float pY = (float)(Mth.lerp((double)partialTicks, (double)this.yo, (double)this.y) - cameraPosition.y);
            float pZ = (float)(Mth.lerp((double)partialTicks, (double)this.zo, (double)this.z) - cameraPosition.z);
            Vec3NT vec = new Vec3NT(this.quadSize, 0.0, this.quadSize).rotateAroundYDeg(this.roll);
            float u0 = this.sprite.getU0();
            float u1 = this.sprite.getU1();
            float v0 = this.sprite.getV0();
            float v1 = this.sprite.getV1();
            int light = this.getLightColor(partialTicks);
            consumer.addVertex((float)((double)pX + vec.xCoord), pY + 0.25f, (float)((double)pZ + vec.zCoord)).setUv(u1, v1).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setNormal(0.0f, 1.0f, 0.0f).setLight(light);
            vec.rotateAroundYDeg(90.0);
            consumer.addVertex((float)((double)pX + vec.xCoord), pY + 0.25f, (float)((double)pZ + vec.zCoord)).setUv(u1, v0).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setNormal(0.0f, 1.0f, 0.0f).setLight(light);
            vec.rotateAroundYDeg(90.0);
            consumer.addVertex((float)((double)pX + vec.xCoord), pY + 0.25f, (float)((double)pZ + vec.zCoord)).setUv(u0, v0).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setNormal(0.0f, 1.0f, 0.0f).setLight(light);
            vec.rotateAroundYDeg(90.0);
            consumer.addVertex((float)((double)pX + vec.xCoord), pY + 0.25f, (float)((double)pZ + vec.zCoord)).setUv(u0, v1).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setNormal(0.0f, 1.0f, 0.0f).setLight(light);
        } else {
            this.renderParticleRotated(consumer, camera, up, left, this.rCol, this.gCol, this.bCol, this.alpha, this.quadSize, partialTicks, this.getLightColor(partialTicks));
        }
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        public TextureSheetParticle createParticle(SimpleParticleType type, ClientLevel world, double x, double y, double z, double dx, double dy, double dz) {
            return new ParticleAshes(world, x, y, z, 0.125f);
        }
    }
}

