/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.particle;

import com.hbm.particle.ParticleRotating;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ParticleExplosionSmall
extends ParticleRotating {
    private final float hue;

    public ParticleExplosionSmall(ClientLevel level, double x, double y, double z, float scale, float speedMult, SpriteSet sprites) {
        super(level, x, y, z);
        this.setSpriteFromAge(sprites);
        this.lifetime = 25 + this.random.nextInt(10);
        this.quadSize = scale * 0.9f + this.random.nextFloat() * 0.2f;
        this.xd = this.random.nextGaussian() * (double)speedMult;
        this.zd = this.random.nextGaussian() * (double)speedMult;
        this.gravity = this.random.nextFloat() * -0.01f;
        this.hue = 20.0f + this.random.nextFloat() * 20.0f;
        Color base = Color.getHSBColor(this.hue / 255.0f, 1.0f, 1.0f);
        this.rCol = (float)base.getRed() / 255.0f;
        this.gCol = (float)base.getGreen() / 255.0f;
        this.bCol = (float)base.getBlue() / 255.0f;
        this.hasPhysics = false;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        ++this.age;
        if (this.age >= this.lifetime) {
            this.remove();
        }
        this.xd -= (double)this.gravity;
        this.oRoll = this.roll;
        float ageScaled = (float)this.age / (float)this.lifetime;
        this.roll += (float)((double)((1.0f - ageScaled) * 5.0f) * ((double)(((Object)((Object)this)).hashCode() % 2) - 0.5));
        this.xd *= 0.65;
        this.zd *= 0.65;
        this.move(this.xd, this.yd, this.zd);
    }

    public void render(VertexConsumer consumer, Camera camera, float partialTicks) {
        Vector3f up = new Vector3f((Vector3fc)camera.getUpVector());
        Vector3f left = new Vector3f((Vector3fc)camera.getLeftVector());
        double ageScaled = (double)((float)this.age + partialTicks) / (double)this.lifetime;
        Color color = Color.getHSBColor(this.hue / 255.0f, Math.max(1.0f - (float)ageScaled * 2.0f, 0.0f), Mth.clamp((float)(1.25f - (float)ageScaled * 2.0f), (float)(this.hue * 0.01f - 0.1f), (float)1.0f));
        this.rCol = (float)color.getRed() / 255.0f;
        this.gCol = (float)color.getGreen() / 255.0f;
        this.bCol = (float)color.getBlue() / 255.0f;
        this.alpha = (float)Math.pow(1.0 - Math.min(ageScaled, 1.0), 0.25);
        float scale = (float)((1.25 - Math.pow(1.0 - ageScaled, 4.0) + (double)((float)this.age + partialTicks) * 0.02) * (double)this.quadSize);
        this.renderParticleRotated(consumer, camera, up, left, this.rCol, this.gCol, this.bCol, this.alpha * 0.5f, scale, partialTicks, 240);
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
            return new ParticleExplosionSmall(level, x, y, z, 1.0f, 0.1f, this.sprites);
        }
    }
}

