/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.particle;

import com.hbm.particle.ModParticles;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ParticleFoam
extends TextureSheetParticle {
    private float baseScale = 1.0f;
    private float maxScale = 1.5f;
    private List<TrailPoint> trail = new ArrayList<TrailPoint>();
    private int trailLength = 15;
    private float initialVelocity;
    private float buoyancy = 0.05f;
    private float jitter = 0.15f;
    private float drag = 0.96f;
    private int explosionPhase;

    public ParticleFoam(ClientLevel level, double x, double y, double z) {
        super(level, x, y, z, 0.0, 0.0, 0.0);
        this.setSpriteFromAge(ModParticles.ROCKET_FLAME_SPRITES);
        this.lifetime = 60 + this.random.nextInt(60);
        this.gravity = 0.005f + this.random.nextFloat() * 0.015f;
        this.initialVelocity = 2.0f + this.random.nextFloat() * 3.0f;
        this.yd = this.initialVelocity;
        double angle = this.random.nextDouble() * Math.PI * 2.0;
        double strength = this.random.nextDouble() * 0.5;
        this.xd = Math.cos(angle) * strength;
        this.zd = Math.sin(angle) * strength;
        this.explosionPhase = 0;
        this.quadSize = 0.3f + this.random.nextFloat() * 0.7f;
    }

    public void setBaseScale(float f) {
        this.baseScale = f;
    }

    public void setMaxScale(float f) {
        this.maxScale = f;
    }

    public void setTrailLength(int length) {
        this.trailLength = length;
    }

    public void setBuoyancy(float buoyancy) {
        this.buoyancy = buoyancy;
    }

    public void tick() {
        float phaseRatio;
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.trail.add(0, new TrailPoint(this.x, this.y, this.z));
        while (this.trail.size() > this.trailLength) {
            this.trail.remove(this.trail.size() - 1);
        }
        ++this.age;
        if (this.age == this.lifetime) {
            this.remove();
        }
        if ((phaseRatio = (float)this.age / (float)this.lifetime) < 0.3f) {
            this.explosionPhase = 0;
            this.yd = phaseRatio < 0.15f ? (this.yd += (double)(this.buoyancy * 6.0f)) : (this.yd += (double)(this.buoyancy * (1.0f - phaseRatio / 0.3f) * 2.0f));
            this.quadSize = this.baseScale + (this.maxScale - this.baseScale) * (phaseRatio / 0.3f);
        } else if (phaseRatio < 0.6f) {
            this.explosionPhase = 1;
            this.yd *= (double)0.98f;
            this.quadSize = this.maxScale;
        } else {
            this.explosionPhase = 2;
            this.yd -= (double)this.gravity;
            this.quadSize = this.maxScale * (1.0f - (phaseRatio - 0.6f) / 0.4f * 0.7f);
        }
        this.alpha = 0.8f * (1.0f - phaseRatio * phaseRatio);
        this.xd += (double)((this.random.nextFloat() - 0.5f) * this.jitter);
        this.zd += (double)((this.random.nextFloat() - 0.5f) * this.jitter);
        this.xd *= (double)this.drag;
        this.yd *= (double)this.drag;
        this.zd *= (double)this.drag;
        this.move(this.xd, this.yd, this.zd);
        if (this.onGround) {
            this.remove();
        }
    }

    public void render(VertexConsumer consumer, Camera camera, float partialTicks) {
        this.renderFoamBubbles(consumer, camera, this.x, this.y, this.z, this.quadSize, this.alpha, partialTicks);
        for (int i = 1; i < this.trail.size(); ++i) {
            TrailPoint point = this.trail.get(i);
            float trailScale = this.quadSize * (1.0f - (float)i / (float)this.trailLength);
            float trailAlpha = this.alpha * (1.0f - (float)i / (float)this.trailLength) * 0.7f;
            this.renderFoamBubbles(consumer, camera, point.x, point.y, point.z, trailScale, trailAlpha, partialTicks);
        }
    }

    private void renderFoamBubbles(VertexConsumer consumer, Camera camera, double x, double y, double z, float scale, float alpha, float partialTicks) {
        Vec3 cameraPosition = camera.getPosition();
        Random urandom = new Random((long)((Object)((Object)this)).hashCode() + (long)(x * 100.0) + (long)(y * 10.0) + (long)z);
        int bubbleCount = this.explosionPhase == 0 ? 8 : (this.explosionPhase == 1 ? 6 : 4);
        for (int i = 0; i < bubbleCount; ++i) {
            float whiteness;
            this.bCol = this.gCol = (whiteness = 0.9f + urandom.nextFloat() * 0.1f);
            this.rCol = this.gCol;
            float bubbleScale = scale * (urandom.nextFloat() * 0.5f + 0.75f);
            float offset = this.explosionPhase == 0 ? 0.4f : (this.explosionPhase == 1 ? 0.6f : 0.9f);
            float pX = (float)(x - cameraPosition.x + urandom.nextGaussian() * (double)offset);
            float pY = (float)(y - cameraPosition.y + urandom.nextGaussian() * (double)offset * (double)0.7f);
            float pZ = (float)(z - cameraPosition.z + urandom.nextGaussian() * (double)offset);
            Vector3f up = new Vector3f((Vector3fc)camera.getUpVector());
            Vector3f left = new Vector3f((Vector3fc)camera.getLeftVector());
            this.renderQuad(consumer, pX, pY, pZ, up, left, bubbleScale, alpha, this.getLightColor(partialTicks));
        }
    }

    private void renderQuad(VertexConsumer consumer, float cx, float cy, float cz, Vector3f up, Vector3f left, float scale, float alpha, int brightness) {
        float u0 = this.sprite.getU0();
        float u1 = this.sprite.getU1();
        float v0 = this.sprite.getV0();
        float v1 = this.sprite.getV1();
        Vector3f l = new Vector3f((Vector3fc)left).mul(scale);
        Vector3f u = new Vector3f((Vector3fc)up).mul(scale);
        consumer.addVertex(cx - l.x - u.x, cy - l.y - u.y, cz - l.z - u.z).setUv(u1, v1).setColor(this.rCol, this.bCol, this.gCol, alpha).setNormal(0.0f, 1.0f, 0.0f).setLight(brightness);
        consumer.addVertex(cx - l.x + u.x, cy - l.y + u.y, cz - l.z + u.z).setUv(u1, v0).setColor(this.rCol, this.bCol, this.gCol, alpha).setNormal(0.0f, 1.0f, 0.0f).setLight(brightness);
        consumer.addVertex(cx + l.x + u.x, cy + l.y + u.y, cz + l.z + u.z).setUv(u0, v0).setColor(this.rCol, this.bCol, this.gCol, alpha).setNormal(0.0f, 1.0f, 0.0f).setLight(brightness);
        consumer.addVertex(cx + l.x - u.x, cy + l.y - u.y, cz + l.z - u.z).setUv(u0, v1).setColor(this.rCol, this.bCol, this.gCol, alpha).setNormal(0.0f, 1.0f, 0.0f).setLight(brightness);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    private static class TrailPoint {
        double x;
        double y;
        double z;

        public TrailPoint(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        public TextureSheetParticle createParticle(SimpleParticleType type, ClientLevel world, double x, double y, double z, double dx, double dy, double dz) {
            return new ParticleFoam(world, x, y, z);
        }
    }
}

