/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.particle;

import java.awt.Color;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SmokeParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;

public class ParticleGasFlame
extends SmokeParticle {
    private final float colorMod = 0.8f + RandomSource.create().nextFloat() * 0.2f;

    public ParticleGasFlame(ClientLevel level, double x, double y, double z, double vx, double vy, double vz, float scale, SpriteSet sprites) {
        super(level, x, y, z, vx, vy * 1.5, vz, scale, sprites);
        this.hasPhysics = false;
        this.lifetime = 30 + RandomSource.create().nextInt(13);
        this.setSize(scale, scale);
        this.updateColor();
    }

    public void tick() {
        double prevY = this.yd;
        super.tick();
        this.updateColor();
        this.yd = prevY;
        this.xd *= 0.75;
        this.yd += 0.005;
        this.zd *= 0.75;
    }

    private void updateColor() {
        float time = (float)this.age / (float)this.lifetime;
        Color color = Color.getHSBColor(Math.max((60.0f - time * 100.0f) / 360.0f, 0.0f), 1.0f - time * 0.25f, 1.0f - time * 0.5f);
        this.rCol = (float)color.getRed() / 255.0f * this.colorMod;
        this.gCol = (float)color.getGreen() / 255.0f * this.colorMod;
        this.bCol = (float)color.getBlue() / 255.0f * this.colorMod;
    }

    public int getLightColor(float partialTick) {
        return 0xF000F0;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double vx, double vy, double vz) {
            return new ParticleGasFlame(level, x, y, z, vx, vy, vz, 1.0f, this.sprites);
        }
    }
}

