/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.particle;

import com.hbm.particle.IParticleRenderType;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;

public class ParticleMukeCloud
extends TextureSheetParticle {
    private final SpriteSet sprites;
    private final float friction;

    public ParticleMukeCloud(ClientLevel level, double x, double y, double z, double mx, double my, double mz, SpriteSet sprites) {
        super(level, x, y, z);
        this.sprites = sprites;
        this.xd = mx;
        this.yd = my;
        this.zd = mz;
        if (this.yd > 0.0) {
            this.friction = 0.9f;
            this.lifetime = this.yd > 0.1 ? 92 + this.random.nextInt(11) + (int)(this.yd * 20.0) : 72 + this.random.nextInt(11);
        } else if (this.yd == 0.0) {
            this.friction = 0.95f;
            this.lifetime = 52 + this.random.nextInt(11);
        } else {
            this.friction = 0.85f;
            this.lifetime = 122 + this.random.nextInt(31);
            this.age = 80;
        }
        this.setSpriteFromAge(sprites);
        this.quadSize = 3.0f;
    }

    public void tick() {
        this.hasPhysics = this.age >= 2;
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
        this.yd -= 0.04 * (double)this.gravity;
        this.move(this.xd, this.yd, this.zd);
        this.xd *= (double)this.friction;
        this.yd *= (double)this.friction;
        this.zd *= (double)this.friction;
        if (this.onGround) {
            this.xd *= 0.7;
            this.zd *= 0.7;
        }
        this.setSpriteFromAge(this.sprites);
    }

    public ParticleRenderType getRenderType() {
        return IParticleRenderType.MUKE_CLOUD;
    }

    protected int getLightColor(float partialTick) {
        return 240;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new ParticleMukeCloud(level, x, y, z, xSpeed, ySpeed, zSpeed, this.sprites);
        }
    }
}

