/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.particle;

import com.hbm.particle.IParticleRenderType;
import com.hbm.particle.ModParticles;
import com.hbm.particle.ParticleMukeCloud;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Random;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ParticleMukeFlash
extends TextureSheetParticle {
    private final boolean bf;
    private final Random rand = new Random();

    public ParticleMukeFlash(ClientLevel level, double x, double y, double z, boolean bf, SpriteSet sprites) {
        super(level, x, y, z);
        this.bf = bf;
        this.lifetime = 20;
        this.setSpriteFromAge(sprites);
    }

    public void tick() {
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
        if (this.age == 15 && !this.bf) {
            this.spawnClouds();
        } else if (this.age == 15) {
            this.spawnCloudsBF();
        }
    }

    private void spawnClouds() {
        int i;
        ParticleEngine engine = Minecraft.getInstance().particleEngine;
        for (double d = 0.0; d <= 1.8; d += 0.1) {
            ParticleMukeCloud fx = new ParticleMukeCloud(this.level, this.x, this.y, this.z, this.rand.nextGaussian() * 0.05, d + this.rand.nextGaussian() * 0.02, this.rand.nextGaussian() * 0.05, ModParticles.MUKE_CLOUD_SPRITES);
            engine.add((Particle)fx);
        }
        for (i = 0; i < 100; ++i) {
            ParticleMukeCloud fx = new ParticleMukeCloud(this.level, this.x, this.y + 0.5, this.z, this.rand.nextGaussian() * 0.5, this.rand.nextInt(5) == 0 ? 0.02 : 0.0, this.rand.nextGaussian() * 0.5, ModParticles.MUKE_CLOUD_SPRITES);
            engine.add((Particle)fx);
        }
        for (i = 0; i < 75; ++i) {
            double dz;
            double dx = this.rand.nextGaussian() * 0.5;
            if (dx * dx + (dz = this.rand.nextGaussian() * 0.5) * dz > 1.5) {
                dx *= 0.5;
                dz *= 0.5;
            }
            double dy = 1.8 + (this.rand.nextDouble() * 3.0 - 1.5) * (0.75 - (dx * dx + dz * dz)) * 0.5;
            ParticleMukeCloud fx = new ParticleMukeCloud(this.level, this.x, this.y, this.z, dx, dy + this.rand.nextGaussian() * 0.02, dz, ModParticles.MUKE_CLOUD_SPRITES);
            engine.add((Particle)fx);
        }
    }

    private void spawnCloudsBF() {
        int i;
        ParticleEngine engine = Minecraft.getInstance().particleEngine;
        for (double d = 0.0; d <= 1.8; d += 0.1) {
            ParticleMukeCloud fx = new ParticleMukeCloud(this.level, this.x, this.y, this.z, this.rand.nextGaussian() * 0.05, d + this.rand.nextGaussian() * 0.02, this.rand.nextGaussian() * 0.05, ModParticles.MUKE_CLOUD_BF_SPRITES);
            engine.add((Particle)fx);
        }
        for (i = 0; i < 100; ++i) {
            ParticleMukeCloud fx = new ParticleMukeCloud(this.level, this.x, this.y + 0.5, this.z, this.rand.nextGaussian() * 0.5, this.rand.nextInt(5) == 0 ? 0.02 : 0.0, this.rand.nextGaussian() * 0.5, ModParticles.MUKE_CLOUD_BF_SPRITES);
            engine.add((Particle)fx);
        }
        for (i = 0; i < 75; ++i) {
            double dz;
            double dx = this.rand.nextGaussian() * 0.5;
            if (dx * dx + (dz = this.rand.nextGaussian() * 0.5) * dz > 1.5) {
                dx *= 0.5;
                dz *= 0.5;
            }
            double dy = 1.8 + (this.rand.nextDouble() * 3.0 - 1.5) * (0.75 - (dx * dx + dz * dz)) * 0.5;
            ParticleMukeCloud fx = new ParticleMukeCloud(this.level, this.x, this.y, this.z, dx, dy + this.rand.nextGaussian() * 0.02, dz, ModParticles.MUKE_CLOUD_BF_SPRITES);
            engine.add((Particle)fx);
        }
    }

    public void render(VertexConsumer consumer, Camera camera, float partialTicks) {
        Vec3 cameraPosition = camera.getPosition();
        float dX = (float)(Mth.lerp((double)partialTicks, (double)this.xo, (double)this.x) - cameraPosition.x);
        float dY = (float)(Mth.lerp((double)partialTicks, (double)this.yo, (double)this.y) - cameraPosition.y);
        float dZ = (float)(Mth.lerp((double)partialTicks, (double)this.zo, (double)this.z) - cameraPosition.z);
        this.alpha = Mth.clamp((float)(1.0f - ((float)this.age + partialTicks) / (float)this.lifetime), (float)0.0f, (float)1.0f);
        this.alpha *= 0.5f;
        float scale = ((float)this.age + partialTicks) * 3.0f + 1.0f;
        this.rCol = 1.0f;
        this.gCol = 0.9f;
        this.bCol = 0.75f;
        Vector3f up = new Vector3f((Vector3fc)camera.getUpVector());
        Vector3f left = new Vector3f((Vector3fc)camera.getLeftVector());
        Random rand = new Random();
        for (int i = 0; i < 24; ++i) {
            rand.setSeed(i * 31 + 1);
            float pX = (float)((double)dX + rand.nextDouble() * 15.0 - 7.5);
            float pY = (float)((double)dY + rand.nextDouble() * 7.5 - 3.75);
            float pZ = (float)((double)dZ + rand.nextDouble() * 15.0 - 7.5);
            this.addBillboardQuad(consumer, pX, pY, pZ, left, up, scale);
        }
    }

    private void addBillboardQuad(VertexConsumer consumer, float cx, float cy, float cz, Vector3f left, Vector3f up, float scale) {
        float u0 = this.sprite.getU0();
        float u1 = this.sprite.getU1();
        float v0 = this.sprite.getV0();
        float v1 = this.sprite.getV1();
        Vector3f l = new Vector3f((Vector3fc)left).mul(scale);
        Vector3f u = new Vector3f((Vector3fc)up).mul(scale);
        consumer.addVertex(cx - l.x - u.x, cy - l.y - u.y, cz - l.z - u.z).setUv(u1, v1).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setNormal(0.0f, 1.0f, 0.0f).setLight(240);
        consumer.addVertex(cx - l.x + u.x, cy - l.y + u.y, cz - l.z + u.z).setUv(u1, v0).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setNormal(0.0f, 1.0f, 0.0f).setLight(240);
        consumer.addVertex(cx + l.x + u.x, cy + l.y + u.y, cz + l.z + u.z).setUv(u0, v0).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setNormal(0.0f, 1.0f, 0.0f).setLight(240);
        consumer.addVertex(cx + l.x - u.x, cy + l.y - u.y, cz + l.z - u.z).setUv(u0, v1).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setNormal(0.0f, 1.0f, 0.0f).setLight(240);
    }

    public ParticleRenderType getRenderType() {
        return IParticleRenderType.PARTICLE_SHEET_ADDITIVE;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double vx, double vy, double vz) {
            return new ParticleMukeFlash(level, x, y, z, false, this.sprites);
        }
    }
}

