/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.particle;

import com.hbm.particle.IParticleRenderType;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class ParticleMukeWave
extends TextureSheetParticle {
    private float waveScale = 45.0f;

    public ParticleMukeWave(ClientLevel level, double x, double y, double z, SpriteSet sprites) {
        super(level, x, y, z);
        this.setSpriteFromAge(sprites);
        this.lifetime = 25;
        this.bCol = 1.0f;
        this.gCol = 1.0f;
        this.rCol = 1.0f;
    }

    public void setup(float scale, int maxAge) {
        this.waveScale = scale;
        this.lifetime = maxAge;
    }

    public void render(VertexConsumer consumer, Camera camera, float partialTicks) {
        Vec3 camPos = camera.getPosition();
        float pX = (float)(Mth.lerp((double)partialTicks, (double)this.xo, (double)this.x) - camPos.x);
        float pY = (float)(Mth.lerp((double)partialTicks, (double)this.yo, (double)this.y) - camPos.y);
        float pZ = (float)(Mth.lerp((double)partialTicks, (double)this.zo, (double)this.z) - camPos.z);
        this.alpha = Mth.clamp((float)(1.0f - ((float)this.age + partialTicks) / (float)this.lifetime), (float)0.0f, (float)1.0f);
        float scale = (1.0f - (float)Math.pow(Math.E, (double)((float)this.age + partialTicks) * -0.125)) * this.waveScale;
        this.renderQuad(consumer, pX, pY, pZ, scale, 240);
    }

    private void renderQuad(VertexConsumer consumer, float cx, float cy, float cz, float scale, int brightness) {
        float u0 = this.sprite.getU0();
        float u1 = this.sprite.getU1();
        float v0 = this.sprite.getV0();
        float v1 = this.sprite.getV1();
        consumer.addVertex(cx - 1.0f * scale, cy - 0.25f, cz - 1.0f * scale).setUv(u1, v1).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setNormal(0.0f, 1.0f, 0.0f).setLight(brightness);
        consumer.addVertex(cx - 1.0f * scale, cy - 0.25f, cz + 1.0f * scale).setUv(u1, v0).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setNormal(0.0f, 1.0f, 0.0f).setLight(brightness);
        consumer.addVertex(cx + 1.0f * scale, cy - 0.25f, cz + 1.0f * scale).setUv(u0, v0).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setNormal(0.0f, 1.0f, 0.0f).setLight(brightness);
        consumer.addVertex(cx + 1.0f * scale, cy - 0.25f, cz - 1.0f * scale).setUv(u0, v1).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setNormal(0.0f, 1.0f, 0.0f).setLight(brightness);
    }

    public ParticleRenderType getRenderType() {
        return IParticleRenderType.PARTICLE_SHEET_ADDITIVE;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
            return new ParticleMukeWave(level, x, y, z, this.sprites);
        }
    }
}

