/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.particle;

import com.hbm.particle.IParticleRenderType;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Random;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ParticleRadiationFog
extends TextureSheetParticle {
    public ParticleRadiationFog(ClientLevel level, double x, double y, double z, SpriteSet sprites) {
        super(level, x, y, z);
        this.lifetime = 100 + this.random.nextInt(40);
        this.quadSize = 7.5f;
        this.bCol = 0.0f;
        this.gCol = 0.0f;
        this.rCol = 0.0f;
        this.setSpriteFromAge(sprites);
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.lifetime < 400) {
            this.lifetime = 400;
        }
        ++this.age;
        if (this.age >= this.lifetime) {
            this.remove();
        }
        this.xd *= 0.96;
        this.yd *= 0.96;
        this.zd *= 0.96;
        if (this.onGround) {
            this.xd *= 0.7;
            this.zd *= 0.7;
        }
    }

    public void render(VertexConsumer consumer, Camera camera, float partialTicks) {
        Vec3 cameraPosition = camera.getPosition();
        this.rCol = 0.85f;
        this.gCol = 0.9f;
        this.bCol = 0.5f;
        this.alpha = (float)Math.sin((double)this.age * Math.PI / 400.0) * 0.225f;
        Random rand = new Random(50L);
        Vector3f up = new Vector3f((Vector3fc)camera.getUpVector());
        Vector3f left = new Vector3f((Vector3fc)camera.getLeftVector());
        for (int i = 0; i < 25; ++i) {
            float dX = (float)((rand.nextGaussian() - 1.0) * 2.5);
            float dY = (float)((rand.nextGaussian() - 1.0) * (double)0.15f);
            float dZ = (float)((rand.nextGaussian() - 1.0) * 2.5);
            float size = rand.nextFloat() * this.quadSize;
            float pX = (float)((double)((float)(Mth.lerp((double)partialTicks, (double)this.xo, (double)this.x) - cameraPosition.x) + dX) + rand.nextGaussian() * 0.5);
            float pY = (float)((double)((float)(Mth.lerp((double)partialTicks, (double)this.yo, (double)this.y) - cameraPosition.y) + dY) + rand.nextGaussian() * 0.5);
            float pZ = (float)((double)((float)(Mth.lerp((double)partialTicks, (double)this.zo, (double)this.z) - cameraPosition.z) + dZ) + rand.nextGaussian() * 0.5);
            this.renderQuad(consumer, pX, pY, pZ, up, left, size, 240);
        }
    }

    private void renderQuad(VertexConsumer consumer, float cx, float cy, float cz, Vector3f up, Vector3f left, float scale, int brightness) {
        float u0 = this.sprite.getU0();
        float u1 = this.sprite.getU1();
        float v0 = this.sprite.getV0();
        float v1 = this.sprite.getV1();
        Vector3f l = new Vector3f((Vector3fc)left).mul(scale);
        Vector3f u = new Vector3f((Vector3fc)up).mul(scale);
        consumer.addVertex(cx - l.x - u.x, cy - l.y - u.y, cz - l.z - u.z).setUv(u1, v1).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setNormal(0.0f, 1.0f, 0.0f).setLight(brightness);
        consumer.addVertex(cx - l.x + u.x, cy - l.y + u.y, cz - l.z + u.z).setUv(u1, v0).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setNormal(0.0f, 1.0f, 0.0f).setLight(brightness);
        consumer.addVertex(cx + l.x + u.x, cy + l.y + u.y, cz + l.z + u.z).setUv(u0, v0).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setNormal(0.0f, 1.0f, 0.0f).setLight(brightness);
        consumer.addVertex(cx + l.x - u.x, cy + l.y - u.y, cz + l.z - u.z).setUv(u0, v1).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setNormal(0.0f, 1.0f, 0.0f).setLight(brightness);
    }

    public ParticleRenderType getRenderType() {
        return IParticleRenderType.FOG;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Provider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new ParticleRadiationFog(level, x, y, z, this.spriteSet);
        }
    }
}

