/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Random;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ParticleRocketFlame
extends TextureSheetParticle {
    private int age;
    private int maxAge;

    public ParticleRocketFlame(ClientLevel level, double x, double y, double z, SpriteSet sprites) {
        super(level, x, y, z);
        this.maxAge = 300 + this.random.nextInt(50);
        this.quadSize = 1.0f;
        this.setSpriteFromAge(sprites);
    }

    public ParticleRocketFlame setScale(float scale) {
        this.quadSize = scale;
        return this;
    }

    public ParticleRocketFlame setMaxAge(int maxAge) {
        this.maxAge = maxAge;
        return this;
    }

    public ParticleRocketFlame setNoClip() {
        this.hasPhysics = false;
        return this;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        ++this.age;
        if (this.age >= this.maxAge) {
            this.remove();
        }
        this.xd *= 0.91;
        this.yd *= 0.91;
        this.zd *= 0.91;
        this.move(this.xd, this.yd, this.zd);
    }

    public void render(VertexConsumer consumer, Camera camera, float partialTicks) {
        Vec3 cameraPosition = camera.getPosition();
        Random urandom = new Random(((Object)((Object)this)).hashCode());
        Vector3f up = new Vector3f((Vector3fc)camera.getUpVector());
        Vector3f left = new Vector3f((Vector3fc)camera.getLeftVector());
        for (int i = 0; i < 10; ++i) {
            float add = urandom.nextFloat() * 0.3f;
            float dark = 1.0f - Math.min((float)this.age / ((float)this.maxAge * 0.25f), 1.0f);
            this.rCol = Mth.clamp((float)(1.0f * dark + add), (float)0.0f, (float)1.0f);
            this.gCol = Mth.clamp((float)(0.6f * dark + add), (float)0.0f, (float)1.0f);
            this.bCol = Mth.clamp((float)(0.0f + add), (float)0.0f, (float)1.0f);
            this.alpha = (float)Math.pow(1.0f - Math.min((float)this.age / (float)this.maxAge, 1.0f), 0.5) * 0.75f;
            float spread = (float)Math.pow((float)this.age / (float)this.maxAge * 4.0f, 1.5) + 1.0f;
            float scale = (urandom.nextFloat() * 0.5f + 0.1f + (float)this.age / (float)this.maxAge * 2.0f) * this.quadSize;
            float pX = (float)(Mth.lerp((double)partialTicks, (double)this.xo, (double)this.x) - cameraPosition.x() + (urandom.nextGaussian() - 1.0) * (double)0.2f * (double)(spread *= this.quadSize));
            float pY = (float)(Mth.lerp((double)partialTicks, (double)this.yo, (double)this.y) - cameraPosition.y() + (urandom.nextGaussian() - 1.0) * (double)0.2f * (double)spread);
            float pZ = (float)(Mth.lerp((double)partialTicks, (double)this.zo, (double)this.z) - cameraPosition.z() + (urandom.nextGaussian() - 1.0) * (double)0.2f * (double)spread);
            this.renderQuad(consumer, pX, pY, pZ, up, left, scale, 240);
        }
    }

    private void renderQuad(VertexConsumer consumer, float cx, float cy, float cz, Vector3f up, Vector3f left, float scale, int brightness) {
        float u0 = this.sprite.getU0();
        float u1 = this.sprite.getU1();
        float v0 = this.sprite.getV0();
        float v1 = this.sprite.getV1();
        Vector3f l = new Vector3f((Vector3fc)left).mul(scale);
        Vector3f u = new Vector3f((Vector3fc)up).mul(scale);
        consumer.addVertex(cx - l.x - u.x, cy - l.y - u.y, cz - l.z - u.z).setUv(u1, v1).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setNormal(0.0f, 1.0f, 0.0f).setLight(brightness);
        consumer.addVertex(cx - l.x + u.x, cy - l.y + u.y, cz - l.z + u.z).setUv(u1, v0).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setNormal(0.0f, 1.0f, 0.0f).setLight(brightness);
        consumer.addVertex(cx + l.x + u.x, cy + l.y + u.y, cz + l.z + u.z).setUv(u0, v0).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setNormal(0.0f, 1.0f, 0.0f).setLight(brightness);
        consumer.addVertex(cx + l.x - u.x, cy + l.y - u.y, cz + l.z - u.z).setUv(u0, v1).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setNormal(0.0f, 1.0f, 0.0f).setLight(brightness);
    }

    public ParticleRocketFlame resetPrevPos() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        return this;
    }

    public ParticleRocketFlame setMotion(double mx, double my, double mz) {
        this.xd = mx;
        this.yd = my;
        this.zd = mz;
        return this;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
            return new ParticleRocketFlame(level, x, y, z, this.sprites);
        }
    }
}

