/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.particle.helper;

import com.hbm.lib.ModSounds;
import com.hbm.particle.ModParticles;
import com.hbm.particle.ParticleDebris;
import com.hbm.particle.ParticleMukeWave;
import com.hbm.particle.ParticleRocketFlame;
import com.hbm.particle.helper.IParticleCreator;
import com.hbm.wiaj.WorldInAJar;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ExplosionCreator
implements IParticleCreator {
    public static final double SPEED_OF_SOUND = 8.575;

    public static void composeEffect(Level level, double x, double y, double z, int cloudCount, float cloudScale, float cloudSpeedMultiplier, float waveScale, int debrisCount, int debrisSize, int debrisRetry, float debrisVelocity, float debrisHorizontalDeviation, float debrisVerticalOffset, float soundRange) {
        CompoundTag tag = new CompoundTag();
        tag.putString("type", "explosionLarge");
        tag.putByte("cloudCount", (byte)cloudCount);
        tag.putFloat("cloudScale", cloudScale);
        tag.putFloat("cloudSpeedMultiplier", cloudSpeedMultiplier);
        tag.putFloat("waveScale", waveScale);
        tag.putByte("debrisCount", (byte)debrisCount);
        tag.putByte("debrisSize", (byte)debrisSize);
        tag.putShort("debrisRetry", (short)debrisRetry);
        tag.putFloat("debrisVelocity", debrisVelocity);
        tag.putFloat("debrisHorizontalDeviation", debrisHorizontalDeviation);
        tag.putFloat("debrisVerticalOffset", debrisVerticalOffset);
        tag.putFloat("soundRange", soundRange);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            IParticleCreator.sendPacket(serverLevel, x, y, z, Math.max(300, (int)soundRange), tag);
        }
    }

    public static void composeEffectSmall(Level level, double x, double y, double z) {
        ExplosionCreator.composeEffect(level, x, y, z, 10, 2.0f, 0.5f, 25.0f, 5, 8, 20, 0.75f, 1.0f, -2.0f, 150.0f);
    }

    public static void composeEffectStandard(Level level, double x, double y, double z) {
        ExplosionCreator.composeEffect(level, x, y, z, 15, 5.0f, 1.0f, 45.0f, 10, 16, 50, 1.0f, 3.0f, -2.0f, 200.0f);
    }

    public static void composeEffectLarge(Level level, double x, double y, double z) {
        ExplosionCreator.composeEffect(level, x, y, z, 30, 6.5f, 2.0f, 65.0f, 25, 16, 50, 1.25f, 3.0f, -2.0f, 350.0f);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void makeParticle(ClientLevel level, Player player, RandomSource rand, double x, double y, double z, CompoundTag data) {
        int cloudCount = data.getByte("cloudCount");
        float cloudScale = data.getFloat("cloudScale");
        float cloudSpeedMultiplier = data.getFloat("cloudSpeedMultiplier");
        float waveScale = data.getFloat("waveScale");
        int debrisCount = data.getByte("debrisCount");
        byte debrisSize = data.getByte("debrisSize");
        int debrisRetry = data.getShort("debrisRetry");
        float debrisVelocity = data.getFloat("debrisVelocity");
        float debrisHorizontalDeviation = data.getFloat("debrisHorizontalDeviation");
        float debrisVerticalOffset = data.getFloat("debrisVerticalOffset");
        float soundRange = data.getFloat("soundRange");
        double distSq = player.distanceToSqr(x, y, z);
        if (distSq <= (double)(soundRange * soundRange)) {
            double dist = Math.sqrt(distSq);
            SoundEvent sound = dist <= (double)soundRange * 0.4 ? (SoundEvent)ModSounds.EXPLOSION_LARGE_NEAR.get() : (SoundEvent)ModSounds.EXPLOSION_LARGE_FAR.get();
            SimpleSoundInstance instance = new SimpleSoundInstance(sound, SoundSource.BLOCKS, 1000.0f, 0.9f + rand.nextFloat() * 0.2f, rand, x, y, z);
            Minecraft.getInstance().getSoundManager().playDelayed((SoundInstance)instance, (int)(dist / 8.575));
        }
        ParticleMukeWave wave = new ParticleMukeWave(level, x, y + 2.0, z, ModParticles.MUKE_WAVE_SPRITES);
        wave.setup(waveScale, (int)(25.0f * waveScale / 45.0f));
        Minecraft.getInstance().particleEngine.add((Particle)wave);
        for (int i = 0; i < cloudCount; ++i) {
            ParticleRocketFlame particle = new ParticleRocketFlame(level, x, y, z, ModParticles.ROCKET_FLAME_SPRITES).setScale(cloudScale);
            particle.resetPrevPos();
            particle.setParticleSpeed(rand.nextGaussian() * 0.5 * (double)cloudSpeedMultiplier, rand.nextDouble() * 3.0 * (double)cloudSpeedMultiplier, rand.nextGaussian() * 0.5 * (double)cloudSpeedMultiplier);
            particle.setMaxAge(70 + rand.nextInt(20));
            particle.setNoClip();
            Minecraft.getInstance().particleEngine.add((Particle)particle);
        }
        for (int c = 0; c < debrisCount; ++c) {
            double oX = rand.nextGaussian() * (double)debrisHorizontalDeviation;
            double oY = debrisVerticalOffset;
            double oZ = rand.nextGaussian() * (double)debrisHorizontalDeviation;
            int cX = (int)Math.floor(x + oX + 0.5);
            int cY = (int)Math.floor(y + oY + 0.5);
            int cZ = (int)Math.floor(z + oZ + 0.5);
            Vec3 motion = new Vec3((double)debrisVelocity, 0.0, 0.0).zRot((float)(-Math.toRadians(45.0f + rand.nextFloat() * 25.0f))).yRot((float)(rand.nextDouble() * Math.PI * 2.0));
            ParticleDebris particle = new ParticleDebris(level, x, y, z, motion.x, motion.y, motion.z);
            WorldInAJar wiaj = new WorldInAJar(debrisSize, debrisSize, debrisSize);
            particle.setWorldInAJar(wiaj);
            if (debrisSize > 0) {
                int middle = debrisSize / 2 - 1;
                for (int i = 0; i < 2; ++i) {
                    for (int j = 0; j < 2; ++j) {
                        for (int k = 0; k < 2; ++k) {
                            wiaj.setBlock(middle + i, middle + j, middle + k, level.getBlockState(new BlockPos(cX + i, cY + j, cZ + k)));
                        }
                    }
                }
                for (int layer = 2; layer <= debrisSize / 2; ++layer) {
                    for (int i = 0; i < debrisRetry; ++i) {
                        int jz;
                        int jy;
                        int jx = -layer + rand.nextInt(layer * 2 + 1);
                        if (wiaj.getBlock(middle + jx + 1, middle + (jy = -layer + rand.nextInt(layer * 2 + 1)), middle + (jz = -layer + rand.nextInt(layer * 2 + 1))).isAir() && wiaj.getBlock(middle + jx - 1, middle + jy, middle + jz).isAir() && wiaj.getBlock(middle + jx, middle + jy + 1, middle + jz).isAir() && wiaj.getBlock(middle + jx, middle + jy - 1, middle + jz).isAir() && wiaj.getBlock(middle + jx, middle + jy, middle + jz + 1).isAir() && wiaj.getBlock(middle + jx, middle + jy, middle + jz - 1).isAir()) continue;
                        wiaj.setBlock(middle + jx, middle + jy, middle + jz, level.getBlockState(new BlockPos(cX + jx, cY + jy, cZ + jz)));
                    }
                }
            }
            Minecraft.getInstance().particleEngine.add((Particle)particle);
        }
    }
}

