/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.entity.effect;

import com.hbm.entity.effect.FalloutRain;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Random;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.levelgen.Heightmap;

public class RenderFallout
extends EntityRenderer<FalloutRain> {
    private static final ResourceLocation FALLOUT_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"hbmsntm", (String)"textures/entity/fallout.png");
    private final Random random = new Random();
    private float[] rainXCoords;
    private float[] rainYCoords;
    private long lastTime = System.nanoTime();

    public RenderFallout(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    public ResourceLocation getTextureLocation(FalloutRain entity) {
        return FALLOUT_TEXTURE;
    }

    public void render(FalloutRain entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer camera = mc.player;
        ClientLevel world = mc.level;
        if (camera == null || world == null) {
            return;
        }
        long time = System.nanoTime();
        float dt = (float)(time - this.lastTime) / 5.0E7f;
        float interp = Math.min(dt, 1.0f);
        this.lastTime = time;
        PoseStack globalPose = new PoseStack();
        this.renderRainSnow(interp, globalPose, bufferSource, world, (LivingEntity)camera);
    }

    public boolean shouldRender(FalloutRain livingEntity, Frustum camera, double camX, double camY, double camZ) {
        return true;
    }

    public void renderRainSnow(float interp, PoseStack pose, MultiBufferSource buffers, ClientLevel world, LivingEntity camera) {
        GraphicsStatus graphics;
        int timer = camera.tickCount;
        float intensity = 1.0f;
        if (intensity <= 0.0f) {
            return;
        }
        if (this.rainXCoords == null) {
            this.rainXCoords = new float[1024];
            this.rainYCoords = new float[1024];
            for (int i = 0; i < 32; ++i) {
                for (int j = 0; j < 32; ++j) {
                    float f2 = j - 16;
                    float f3 = i - 16;
                    float f4 = Mth.sqrt((float)(f2 * f2 + f3 * f3));
                    this.rainXCoords[i << 5 | j] = -f3 / f4;
                    this.rainYCoords[i << 5 | j] = f2 / f4;
                }
            }
        }
        boolean fancy = (graphics = (GraphicsStatus)Minecraft.getInstance().options.graphicsMode().get()) == GraphicsStatus.FANCY || graphics == GraphicsStatus.FABULOUS;
        int renderLayerCount = fancy ? 10 : 5;
        double camX = camera.xOld + (camera.getX() - camera.xOld) * (double)interp;
        double camY = camera.yOld + (camera.getY() - camera.yOld) * (double)interp;
        double camZ = camera.zOld + (camera.getZ() - camera.zOld) * (double)interp;
        int playerX = Mth.floor((double)camera.getX());
        int playerY = Mth.floor((double)camera.getY());
        int playerZ = Mth.floor((double)camera.getZ());
        pose.pushPose();
        pose.translate(-camX, -camY, -camZ);
        VertexConsumer consumer = buffers.getBuffer(RenderType.entityTranslucent((ResourceLocation)FALLOUT_TEXTURE));
        int overlay = OverlayTexture.NO_OVERLAY;
        int maxLight = 0xF000F0;
        for (int layerZ = playerZ - renderLayerCount; layerZ <= playerZ + renderLayerCount; ++layerZ) {
            for (int layerX = playerX - renderLayerCount; layerX <= playerX + renderLayerCount; ++layerX) {
                int rainCoord = (layerZ - playerZ + 16) * 32 + layerX - playerX + 16;
                float rainCoordX = this.rainXCoords[rainCoord] * 0.5f;
                float rainCoordY = this.rainYCoords[rainCoord] * 0.5f;
                int rainHeight = world.getHeight(Heightmap.Types.MOTION_BLOCKING, layerX, layerZ);
                int minHeight = playerY - renderLayerCount;
                int maxHeight = playerY + renderLayerCount;
                if (minHeight < rainHeight) {
                    minHeight = rainHeight;
                }
                if (maxHeight < rainHeight) {
                    maxHeight = rainHeight;
                }
                if (minHeight == maxHeight) continue;
                this.random.setSeed((long)(layerX * layerX) * 3121L + (long)layerX * 45238971L ^ (long)(layerZ * layerZ) * 418711L + (long)layerZ * 13761L);
                float swayLoop = ((float)(timer & 0x1FF) + interp) / 512.0f;
                float fallVariation = 0.4f + this.random.nextFloat() * 0.2f;
                float swayVariation = this.random.nextFloat();
                double distX = (double)layerX + 0.5 - camera.getX();
                double distZ = (double)layerZ + 0.5 - camera.getZ();
                float intensityMod = Mth.sqrt((float)((float)(distX * distX + distZ * distZ))) / (float)renderLayerCount;
                float alpha = ((1.0f - intensityMod * intensityMod) * 0.3f + 0.5f) * intensity;
                float u0 = 0.0f + fallVariation;
                float u1 = 1.0f + fallVariation;
                float vMin = (float)minHeight / 4.0f + swayLoop + swayVariation;
                float vMax = (float)maxHeight / 4.0f + swayLoop + swayVariation;
                int argb = FastColor.ARGB32.color((int)((int)(alpha * 255.0f)), (int)255, (int)255, (int)255);
                float vx0 = (float)((double)((float)layerX - rainCoordX) + 0.5);
                float vz0 = (float)((double)((float)layerZ - rainCoordY) + 0.5);
                float vx1 = (float)((double)((float)layerX + rainCoordX) + 0.5);
                float vz1 = (float)((double)((float)layerZ + rainCoordY) + 0.5);
                consumer.addVertex(pose.last().pose(), vx0, (float)minHeight, vz0).setColor(argb).setUv(u0, vMin).setOverlay(overlay).setLight(maxLight).setNormal(0.0f, 1.0f, 0.0f);
                consumer.addVertex(pose.last().pose(), vx1, (float)minHeight, vz1).setColor(argb).setUv(u1, vMin).setOverlay(overlay).setLight(maxLight).setNormal(0.0f, 1.0f, 0.0f);
                consumer.addVertex(pose.last().pose(), vx1, (float)maxHeight, vz1).setColor(argb).setUv(u1, vMax).setOverlay(overlay).setLight(maxLight).setNormal(0.0f, 1.0f, 0.0f);
                consumer.addVertex(pose.last().pose(), vx0, (float)maxHeight, vz0).setColor(argb).setUv(u0, vMax).setOverlay(overlay).setLight(maxLight).setNormal(0.0f, 1.0f, 0.0f);
            }
        }
        pose.popPose();
    }
}

