/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.entity.effect;

import com.hbm.HBMsNTMClient;
import com.hbm.entity.effect.NukeTorex;
import com.hbm.lib.ModSounds;
import com.hbm.render.CustomRenderTypes;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Random;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class RenderTorex
extends EntityRenderer<NukeTorex> {
    private static final ResourceLocation CLOUDLET = ResourceLocation.fromNamespaceAndPath((String)"hbmsntm", (String)"textures/particle/particle_base.png");
    private static final ResourceLocation FLASH = ResourceLocation.fromNamespaceAndPath((String)"hbmsntm", (String)"textures/particle/flare.png");
    private final Comparator<NukeTorex.Cloudlet> cloudSorter = (a, b) -> {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return 0;
        }
        double d1 = player.distanceToSqr(a.posX, a.posY, a.posZ);
        double d2 = player.distanceToSqr(b.posX, b.posY, b.posZ);
        return Double.compare(d2, d1);
    };

    public RenderTorex(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(NukeTorex entity, float yaw, float partialTicks, PoseStack pose, MultiBufferSource buffers, int packedLight) {
        pose.pushPose();
        pose.translate(0.0f, 0.0f, 0.0f);
        this.cloudletWrapper(entity, partialTicks, pose, buffers);
        if (entity.tickCount < 101) {
            this.flashWrapper(entity, partialTicks, pose, buffers);
        }
        if (entity.tickCount < 10 && System.currentTimeMillis() - HBMsNTMClient.flashTimestamp > 1000L) {
            HBMsNTMClient.flashTimestamp = System.currentTimeMillis();
        }
        if (entity.didPlaySound && !entity.didShake && System.currentTimeMillis() - HBMsNTMClient.shakeTimestamp > 1000L) {
            HBMsNTMClient.shakeTimestamp = System.currentTimeMillis();
            entity.didShake = true;
            LocalPlayer player = Minecraft.getInstance().player;
            if (player != null) {
                player.hurtDuration = 15;
                player.hurtTime = 15;
            }
        }
        pose.popPose();
    }

    public static void handleExplosionEffect(NukeTorex entity, int tickCount) {
        double radius;
        double dist;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && (dist = (double)player.distanceTo((Entity)entity)) < (radius = ((double)tickCount * 1.5 + 1.0) * 1.5)) {
            entity.level().playLocalSound(entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)ModSounds.NUCLEAR_EXPLOSION.get(), SoundSource.AMBIENT, 10000.0f, 1.0f, false);
            entity.didPlaySound = true;
        }
    }

    private void cloudletWrapper(NukeTorex cloud, float partialTicks, PoseStack pose, MultiBufferSource buffers) {
        VertexConsumer consumer = buffers.getBuffer(CustomRenderTypes.entityTranslucent((ResourceLocation)CLOUDLET));
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        RenderSystem.depthMask((boolean)false);
        ArrayList<NukeTorex.Cloudlet> cloudlets = new ArrayList<NukeTorex.Cloudlet>(cloud.cloudlets);
        cloudlets.sort(this.cloudSorter);
        for (NukeTorex.Cloudlet cloudlet : cloudlets) {
            Vec3 vec = cloudlet.getInterpPos(partialTicks);
            double x = vec.x - cloud.getX();
            double y = vec.y - cloud.getY();
            double z = vec.z - cloud.getZ();
            this.renderCloudlet(consumer, pose, x, y, z, cloudlet, partialTicks);
        }
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
    }

    private void flashWrapper(NukeTorex cloud, float partialTicks, PoseStack pose, MultiBufferSource buffers) {
        VertexConsumer consumer = buffers.getBuffer(CustomRenderTypes.additive(FLASH));
        double age = Math.min((float)cloud.tickCount + partialTicks, 100.0f);
        float alpha = (float)((100.0 - age) / 100.0);
        Random rand = new Random(cloud.getId());
        for (int i = 0; i < 3; ++i) {
            float x = (float)(rand.nextGaussian() * 0.5 * cloud.rollerSize);
            float y = (float)(rand.nextGaussian() * 0.5 * cloud.rollerSize);
            float z = (float)(rand.nextGaussian() * 0.5 * cloud.rollerSize);
            this.renderFlash(consumer, pose, x, (double)y + cloud.coreHeight, z, (float)(25.0 * cloud.rollerSize), alpha);
        }
    }

    private void renderCloudlet(VertexConsumer consumer, PoseStack pose, double px, double py, double pz, NukeTorex.Cloudlet cloud, float partialTicks) {
        float alpha = cloud.getAlpha();
        float scale = cloud.getScale();
        float brightness = cloud.type == NukeTorex.TorexType.CONDENSATION ? 0.9f : 0.75f * cloud.colorMod;
        Vec3 color = cloud.getInterpColor(partialTicks);
        float r = (float)Mth.clamp((double)(color.x * (double)brightness), (double)0.0, (double)1.0);
        float g = (float)Mth.clamp((double)(color.y * (double)brightness), (double)0.0, (double)1.0);
        float b = (float)Mth.clamp((double)(color.z * (double)brightness), (double)0.0, (double)1.0);
        this.drawBillboardQuad(consumer, pose, px, py, pz, scale, r, g, b, alpha);
    }

    private void renderFlash(VertexConsumer consumer, PoseStack pose, double px, double py, double pz, float scale, float alpha) {
        this.drawBillboardQuad(consumer, pose, px, py, pz, scale, 1.0f, 1.0f, 1.0f, alpha);
    }

    private void drawBillboardQuad(VertexConsumer consumer, PoseStack pose, double px, double py, double pz, float scale, float r, float g, float b, float a) {
        PoseStack.Pose last = pose.last();
        Matrix4f matrix = last.pose();
        Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
        Quaternionf camRot = camera.rotation();
        Matrix3f camMat = new Matrix3f();
        camRot.get(camMat);
        Vector3f right = new Vector3f(1.0f, 0.0f, 0.0f).mul((Matrix3fc)camMat).mul(scale);
        Vector3f up = new Vector3f(0.0f, 1.0f, 0.0f).mul((Matrix3fc)camMat).mul(scale);
        Vector3f normal = last.normal().transform(new Vector3f(0.0f, 1.0f, 0.0f));
        int color = FastColor.ARGB32.color((int)((int)(a * 255.0f)), (int)((int)(r * 255.0f)), (int)((int)(g * 255.0f)), (int)((int)(b * 255.0f)));
        int light = 240;
        int overlay = OverlayTexture.NO_OVERLAY;
        float u0 = 0.0f;
        float v0 = 0.0f;
        float u1 = 1.0f;
        float v1 = 1.0f;
        consumer.addVertex(matrix, (float)(px - (double)right.x() - (double)up.x()), (float)(py - (double)right.y() - (double)up.y()), (float)(pz - (double)right.z() - (double)up.z())).setColor(color).setUv(u1, v1).setOverlay(overlay).setLight(light).setNormal(normal.x(), normal.y(), normal.z());
        consumer.addVertex(matrix, (float)(px - (double)right.x() + (double)up.x()), (float)(py - (double)right.y() + (double)up.y()), (float)(pz - (double)right.z() + (double)up.z())).setColor(color).setUv(u1, v0).setOverlay(overlay).setLight(light).setNormal(normal.x(), normal.y(), normal.z());
        consumer.addVertex(matrix, (float)(px + (double)right.x() + (double)up.x()), (float)(py + (double)right.y() + (double)up.y()), (float)(pz + (double)right.z() + (double)up.z())).setColor(color).setUv(u0, v0).setOverlay(overlay).setLight(light).setNormal(normal.x(), normal.y(), normal.z());
        consumer.addVertex(matrix, (float)(px + (double)right.x() - (double)up.x()), (float)(py + (double)right.y() - (double)up.y()), (float)(pz + (double)right.z() - (double)up.z())).setColor(color).setUv(u0, v1).setOverlay(overlay).setLight(light).setNormal(normal.x(), normal.y(), normal.z());
    }

    public ResourceLocation getTextureLocation(NukeTorex entity) {
        return null;
    }
}

