/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.entity.item;

import com.hbm.entity.item.EntityTNTPrimedBase;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;

public class RenderTNTPrimedBase
extends EntityRenderer<EntityTNTPrimedBase> {
    private final BlockRenderDispatcher blockRenderer;

    public RenderTNTPrimedBase(EntityRendererProvider.Context context) {
        super(context);
        this.shadowRadius = 0.5f;
        this.blockRenderer = Minecraft.getInstance().getBlockRenderer();
    }

    public void render(EntityTNTPrimedBase tnt, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        BlockState blockstate = tnt.getBlock().defaultBlockState();
        int fuse = tnt.fuse;
        float f = (float)fuse - partialTicks + 1.0f;
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.5f, 0.0f);
        poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
        if (f < 10.0f) {
            float scale = 1.0f - f / 10.0f;
            scale = Mth.clamp((float)scale, (float)0.0f, (float)1.0f);
            scale = scale * scale * scale * scale;
            float finalScale = 1.0f + scale * 0.3f;
            poseStack.scale(finalScale, finalScale, finalScale);
        }
        poseStack.translate(-0.5f, -0.5f, -0.5f);
        this.blockRenderer.renderSingleBlock(blockstate, poseStack, buffer, packedLight, OverlayTexture.NO_OVERLAY);
        if (tnt.fuse / 5 % 2 == 0) {
            float alpha = (1.0f - f / 100.0f) * 0.8f;
            RenderSystem.disableDepthTest();
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_CONSTANT_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            this.blockRenderer.renderSingleBlock(blockstate, poseStack, buffer, packedLight, OverlayTexture.NO_OVERLAY);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
            RenderSystem.enableDepthTest();
        }
        poseStack.popPose();
        super.render((Entity)tnt, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(EntityTNTPrimedBase entity) {
        return TextureAtlas.LOCATION_BLOCKS;
    }
}

