/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.entity.projectile;

import com.hbm.entity.projectile.EntityShrapnel;
import com.hbm.render.entity.projectile.ModelShrapnel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class RenderShrapnel
extends EntityRenderer<EntityShrapnel> {
    private static final ResourceLocation SHRAPNEL = ResourceLocation.fromNamespaceAndPath((String)"hbmsntm", (String)"textures/entity/shrapnel.png");
    private final ModelShrapnel<EntityShrapnel> model;

    public RenderShrapnel(EntityRendererProvider.Context context) {
        super(context);
        this.model = new ModelShrapnel(context.bakeLayer(ModelShrapnel.LAYER_LOCATION));
    }

    public void render(EntityShrapnel entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.pushPose();
        poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
        float rotation = (float)(entity.tickCount % 360 * 10) + partialTicks;
        poseStack.mulPose(Axis.XP.rotationDegrees(rotation));
        poseStack.mulPose(Axis.YP.rotationDegrees(rotation));
        poseStack.mulPose(Axis.ZP.rotationDegrees(rotation));
        VertexConsumer vertexconsumer = buffer.getBuffer(this.model.renderType(this.getTextureLocation(entity)));
        this.model.renderToBuffer(poseStack, vertexconsumer, packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
        super.render((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(EntityShrapnel entityShrapnel) {
        return SHRAPNEL;
    }
}

