/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.entity.LivingEntity;

public class ModelGasMask<T extends LivingEntity>
extends HumanoidModel<T> {
    private final ModelPart mask;

    public ModelGasMask(ModelPart root) {
        super(root, RenderType::entityCutoutNoCull);
        this.mask = root.getChild("mask");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = HumanoidModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)0.0f);
        PartDefinition root = mesh.getRoot();
        PartDefinition mask = root.addOrReplaceChild("mask", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 3.0f).texOffs(22, 0).addBox(-3.0f, -5.0f, -4.5f, 2.0f, 2.0f, 1.0f).texOffs(22, 0).addBox(1.0f, -5.0f, -4.5f, 2.0f, 2.0f, 1.0f).texOffs(0, 11).addBox(-1.0f, -3.0f, -4.0f, 2.0f, 2.0f, 2.0f).texOffs(0, 15).addBox(-0.5f, -1.0f, -4.0f, 3.0f, 4.0f, 3.0f).texOffs(0, 22).addBox(-4.0f, -5.0f, -1.0f, 8.0f, 1.0f, 5.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)32);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.mask.copyFrom(this.head);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        super.renderToBuffer(poseStack, buffer, packedLight, packedOverlay, color);
        poseStack.pushPose();
        poseStack.scale(1.15f, 1.15f, 1.15f);
        this.mask.render(poseStack, buffer, packedLight, packedOverlay, color);
        poseStack.popPose();
    }
}

