/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.util;

import api.hbm.item.IGasMask;
import com.hbm.handler.ArmorModHandler;
import com.hbm.util.ArmorUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ArmorRegistry {
    public static HashMap<Item, ArrayList<HazardClass>> hazardClasses = new HashMap();

    public static void registerHazard(Item item, HazardClass ... hazards) {
        hazardClasses.put(item, new ArrayList<HazardClass>(Arrays.asList(hazards)));
    }

    public static boolean hasAllProtection(LivingEntity entity, int slot, HazardClass ... clazz) {
        if (ArmorUtil.checkArmorNull(entity, slot)) {
            return false;
        }
        EquipmentSlot eqSlot = ArmorUtil.toEquipmentSlot(slot);
        ItemStack stack = entity.getItemBySlot(eqSlot);
        List<HazardClass> list = ArmorRegistry.getProtectionFromItem(stack, entity);
        return new HashSet<HazardClass>(list).containsAll(Arrays.asList(clazz));
    }

    public static boolean hasAnyProtection(LivingEntity entity, int slot, HazardClass ... clazz) {
        if (ArmorUtil.checkArmorNull(entity, slot)) {
            return false;
        }
        EquipmentSlot eqSlot = ArmorUtil.toEquipmentSlot(slot);
        ItemStack stack = entity.getItemBySlot(eqSlot);
        List<HazardClass> list = ArmorRegistry.getProtectionFromItem(stack, entity);
        if (list == null) {
            return false;
        }
        for (HazardClass haz : clazz) {
            if (!list.contains((Object)haz)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasProtection(LivingEntity entity, int slot, HazardClass clazz) {
        if (ArmorUtil.checkArmorNull(entity, slot)) {
            return false;
        }
        EquipmentSlot eqSlot = ArmorUtil.toEquipmentSlot(slot);
        ItemStack stack = entity.getItemBySlot(eqSlot);
        List<HazardClass> list = ArmorRegistry.getProtectionFromItem(stack, entity);
        return list.contains((Object)clazz);
    }

    public static List<HazardClass> getProtectionFromItem(ItemStack stack, LivingEntity entity) {
        IGasMask mask;
        ItemStack filter;
        ArrayList<HazardClass> prot = new ArrayList<HazardClass>();
        Item item = stack.getItem();
        if (hazardClasses.containsKey(item)) {
            prot.addAll((Collection)hazardClasses.get(item));
        }
        if (item instanceof IGasMask && (filter = (mask = (IGasMask)item).getFilter(stack, entity)) != null) {
            List filProt = (List)hazardClasses.get(filter.getItem()).clone();
            for (HazardClass c : mask.getBlacklist(stack, entity)) {
                filProt.remove((Object)c);
            }
            prot.addAll(filProt);
        }
        if (ArmorModHandler.hasMods(stack)) {
            ItemStack[] mods;
            for (ItemStack mod : mods = ArmorModHandler.pryMods(stack)) {
                if (mod == null) continue;
                prot.addAll(ArmorRegistry.getProtectionFromItem(mod, entity));
            }
        }
        return prot;
    }

    public static enum HazardClass {
        GAS_LUNG((Component)Component.translatable((String)"hazard.gasChlorine")),
        GAS_MONOXIDE((Component)Component.translatable((String)"hazard.gasMonoxide")),
        GAS_INERT((Component)Component.translatable((String)"hazard.gasInert")),
        PARTICLE_COARSE((Component)Component.translatable((String)"hazard.particleCoarse")),
        PARTICLE_FINE((Component)Component.translatable((String)"hazard.particleFine")),
        BACTERIA((Component)Component.translatable((String)"hazard.bacteria")),
        GAS_BLISTERING((Component)Component.translatable((String)"hazard.corrosive")),
        SAND((Component)Component.translatable((String)"hazard.sand")),
        LIGHT((Component)Component.translatable((String)"hazard.light"));

        public final Component component;

        private HazardClass(Component component) {
            this.component = component;
        }
    }
}

