/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.util;

import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ArmorUtil {
    private static final EquipmentSlot[] SLOT_MAP = new EquipmentSlot[]{EquipmentSlot.FEET, EquipmentSlot.LEGS, EquipmentSlot.CHEST, EquipmentSlot.HEAD};

    public void register() {
    }

    public static boolean checkArmor(LivingEntity entity, Item ... armor) {
        for (int i = 0; i < 4; ++i) {
            if (ArmorUtil.checkArmorPiece(entity, armor[i], 3 - i)) continue;
            return false;
        }
        return true;
    }

    public static boolean checkArmorPiece(LivingEntity entity, Item armor, int slot) {
        EquipmentSlot eqSlot = ArmorUtil.toEquipmentSlot(slot);
        ItemStack stack = entity.getItemBySlot(eqSlot);
        return !stack.isEmpty() && stack.getItem() == armor;
    }

    public static void damageSuit(LivingEntity entity, int slot, int amount) {
        EquipmentSlot eqSlot = ArmorUtil.toEquipmentSlot(slot);
        ItemStack stack = entity.getItemBySlot(eqSlot);
        if (stack == ItemStack.EMPTY) {
            return;
        }
        stack.hurtAndBreak(amount, entity, eqSlot);
    }

    public static boolean checkArmorNull(LivingEntity entity, int slot) {
        EquipmentSlot eqSlot = ArmorUtil.toEquipmentSlot(slot);
        return entity.getItemBySlot(eqSlot).isEmpty();
    }

    protected static EquipmentSlot toEquipmentSlot(int oldSlot) {
        if (oldSlot < 0 || oldSlot >= SLOT_MAP.length) {
            throw new IllegalArgumentException("Illegal armor slot: " + oldSlot);
        }
        return SLOT_MAP[oldSlot];
    }
}

