/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.util;

import api.hbm.entity.IRadiationImmune;
import com.hbm.entity.mob.CreeperNuclear;
import com.hbm.entity.mob.Duck;
import com.hbm.extprop.LivingProperties;
import com.hbm.handler.radiation.ChunkRadiationManager;
import com.hbm.lib.ModEffect;
import java.util.HashSet;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class ContaminationUtil {
    public static HashSet<Class<?>> immuneEntities = new HashSet();

    public static boolean isRadImmune(Entity entity) {
        if (entity instanceof LivingEntity && ((LivingEntity)entity).hasEffect(ModEffect.MUTATION)) {
            return true;
        }
        if (immuneEntities.isEmpty()) {
            immuneEntities.add(CreeperNuclear.class);
            immuneEntities.add(MushroomCow.class);
            immuneEntities.add(Zombie.class);
            immuneEntities.add(Skeleton.class);
            immuneEntities.add(Ocelot.class);
            immuneEntities.add(IRadiationImmune.class);
        }
        Class<?> entityClass = entity.getClass();
        for (Class<?> clazz : immuneEntities) {
            if (!clazz.isAssignableFrom(entityClass)) continue;
            return true;
        }
        return false;
    }

    public static void applyDigammaData(Entity entity, float dig) {
        ServerPlayer player;
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity e = (LivingEntity)entity;
        if (entity instanceof Duck || entity instanceof Ocelot) {
            return;
        }
        if (entity instanceof ServerPlayer && (player = (ServerPlayer)entity).isCreative()) {
            return;
        }
        if (entity instanceof ServerPlayer) {
            player = (ServerPlayer)entity;
            if (player.tickCount < 200) {
                return;
            }
        }
        LivingProperties.incrementDigamma(e, dig);
    }

    public static float calculateRadiationMod(LivingEntity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            float f = 10.0f;
        }
        return 1.0f;
    }

    public static void printGeigerData(Player player) {
        Level level = player.level();
        float eRad = (float)((double)(LivingProperties.getRadiation((LivingEntity)player) * 10.0f) / 10.0);
        double rads = Math.floor(ChunkRadiationManager.proxy.getRadiation(level, player.blockPosition().getX(), player.blockPosition().getY(), player.blockPosition().getZ()) * 10.0f) / 10.0;
        double env = Math.floor((double)LivingProperties.getRadBuf((LivingEntity)player) * 10.0) / 10.0;
        double res = Math.floor(10000.0 - (double)ContaminationUtil.calculateRadiationMod((LivingEntity)player) * 10000.0) / 100.0;
        String chunkPrefix = ContaminationUtil.getPrefixFromRad(rads);
        String envPrefix = ContaminationUtil.getPrefixFromRad(env);
        Object radPrefix = "";
        radPrefix = eRad < 200.0f ? (String)radPrefix + String.valueOf(ChatFormatting.GREEN) : (eRad < 400.0f ? (String)radPrefix + String.valueOf(ChatFormatting.YELLOW) : (eRad < 600.0f ? (String)radPrefix + String.valueOf(ChatFormatting.GOLD) : (eRad < 800.0f ? (String)radPrefix + String.valueOf(ChatFormatting.RED) : (eRad < 1000.0f ? (String)radPrefix + String.valueOf(ChatFormatting.DARK_RED) : (String)radPrefix + String.valueOf(ChatFormatting.DARK_GRAY)))));
        player.displayClientMessage((Component)Component.literal((String)"===== \u2622 ").append((Component)Component.translatable((String)"geiger.title")).append((Component)Component.literal((String)" \u2622 =====")).setStyle(Style.EMPTY.withColor(ChatFormatting.GOLD)), false);
        player.displayClientMessage((Component)Component.translatable((String)"geiger.chunkRad").append((Component)Component.literal((String)(" " + chunkPrefix + rads + " RAD/s"))).setStyle(Style.EMPTY.withColor(ChatFormatting.YELLOW)), false);
        player.displayClientMessage((Component)Component.translatable((String)"geiger.envRad").append((Component)Component.literal((String)(" " + envPrefix + env + " RAD/s"))).setStyle(Style.EMPTY.withColor(ChatFormatting.YELLOW)), false);
        player.displayClientMessage((Component)Component.translatable((String)"geiger.playerRad").append((Component)Component.literal((String)(" " + (String)radPrefix + eRad + " RAD"))).setStyle(Style.EMPTY.withColor(ChatFormatting.YELLOW)), false);
    }

    public static void printDosimeterData(Player player) {
        double env = (double)((int)((double)LivingProperties.getRadBuf((LivingEntity)player) * 10.0)) / 10.0;
        boolean limit = false;
        if (env > 3.6) {
            env = 3.6;
            limit = true;
        }
        String envPrefix = ContaminationUtil.getPrefixFromRad(env);
        player.displayClientMessage((Component)Component.literal((String)"===== \u2622 ").append((Component)Component.translatable((String)"geiger.title.dosimeter")).append((Component)Component.literal((String)" \u2622 =====")).setStyle(Style.EMPTY.withColor(ChatFormatting.GOLD)), false);
        player.displayClientMessage((Component)Component.translatable((String)"geiger.envRad").append((Component)Component.literal((String)(" " + envPrefix + (limit ? ">" : "") + env + " RAD/s"))).setStyle(Style.EMPTY.withColor(ChatFormatting.YELLOW)), false);
    }

    public static String getPrefixFromRad(double rads) {
        if (rads == 0.0) {
            return ChatFormatting.GREEN.toString();
        }
        if (rads < 1.0) {
            return ChatFormatting.YELLOW.toString();
        }
        if (rads < 10.0) {
            return ChatFormatting.GOLD.toString();
        }
        if (rads < 100.0) {
            return ChatFormatting.RED.toString();
        }
        if (rads < 1000.0) {
            return ChatFormatting.DARK_RED.toString();
        }
        return ChatFormatting.DARK_GRAY.toString();
    }

    public static void printDiagnosticData(Player player) {
        double digamma = (double)((int)(LivingProperties.getDigamma((LivingEntity)player) * 100.0f)) / 100.0;
        double halflife = (double)((int)((1.0 - Math.pow(0.5, digamma)) * 10000.0)) / 100.0;
        player.displayClientMessage((Component)Component.literal((String)"===== \u03dc ").append((Component)Component.translatable((String)"digamma.title")).append((Component)Component.literal((String)" \u03dc =====")).setStyle(Style.EMPTY.withColor(ChatFormatting.DARK_PURPLE)), false);
        player.displayClientMessage((Component)Component.translatable((String)"digamma.playerDigamma").withStyle(ChatFormatting.LIGHT_PURPLE).append((Component)Component.literal((String)(" " + digamma + " DRX")).withStyle(ChatFormatting.RED)), false);
        player.displayClientMessage((Component)Component.translatable((String)"digamma.playerHealth").withStyle(ChatFormatting.LIGHT_PURPLE).append((Component)Component.literal((String)(" " + halflife + " %")).withStyle(ChatFormatting.RED)), false);
        player.displayClientMessage((Component)Component.translatable((String)"digamma.playerRes").withStyle(ChatFormatting.LIGHT_PURPLE).append((Component)Component.literal((String)" N/A").withStyle(ChatFormatting.BLUE)), false);
    }

    public static void contaminate(LivingEntity entity, HazardType hazard, ContaminationType type, float amount) {
        if (hazard == HazardType.RADIATION) {
            float radEnv = LivingProperties.getRadEnv(entity);
            LivingProperties.setRadEnv(entity, radEnv + amount);
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (player.isCreative() || player.isSpectator() && type != ContaminationType.NONE && type != ContaminationType.DIGAMMA_ROBE) {
                return;
            }
            if (player.tickCount < 200) {
                return;
            }
        }
        if (hazard == HazardType.RADIATION && ContaminationUtil.isRadImmune((Entity)entity)) {
            return;
        }
        switch (hazard.ordinal()) {
            case 0: {
                LivingProperties.incrementRadiation(entity, amount * (type == ContaminationType.RAD_BYPASS ? 1.0f : ContaminationUtil.calculateRadiationMod(entity)));
                break;
            }
            case 1: {
                LivingProperties.incrementDigamma(entity, amount);
            }
        }
    }

    public static enum HazardType {
        RADIATION,
        DIGAMMA;

    }

    public static enum ContaminationType {
        FARADAY,
        HAZMAT,
        HAZMAT_HEAVY,
        DIGAMMA,
        DIGAMMA_ROBE,
        CREATIVE,
        RAD_BYPASS,
        NONE;

    }
}

