/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.util;

import com.hbm.util.DamageResistanceHandler;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class EntityDamageUtil {
    public static boolean hurtNT(LivingEntity living, DamageSource source, float amount, boolean ignoreIFrame, boolean allowSpecialCancel, double knockbackMultiplier, float pierceDT, float pierce) {
        if (living instanceof ServerPlayer) {
            Player attacker;
            ServerPlayer serverPlayer = (ServerPlayer)living;
            Entity entity = source.getEntity();
            if (entity instanceof Player && !serverPlayer.canHarmPlayer(attacker = (Player)entity)) {
                return false;
            }
        }
        DamageResistanceHandler.setup(pierceDT, pierce);
        boolean ret = EntityDamageUtil.attackEntityFromNTInternal(living, source, amount, ignoreIFrame, allowSpecialCancel, knockbackMultiplier);
        DamageResistanceHandler.reset();
        return ret;
    }

    private static boolean attackEntityFromNTInternal(LivingEntity living, DamageSource source, float amount, boolean ignoreIFrame, boolean allowSpecialCancel, double knockbackMultiplier) {
        if (allowSpecialCancel) {
            return true;
        }
        Entity entity = source.getEntity();
        if (entity != null) {
            double deltaX = entity.getX() - living.getX();
            double deltaZ = entity.getZ() - living.getZ();
            while (deltaX * deltaX + deltaZ * deltaZ < 1.0E-4) {
                deltaX = (Math.random() - Math.random()) * 0.01;
                deltaZ = (Math.random() - Math.random()) * 0.01;
            }
            EntityDamageUtil.knockBack(living, entity, amount, deltaX, deltaZ, knockbackMultiplier);
        }
        return living.hurt(source, amount);
    }

    public static void knockBack(LivingEntity living, Entity attacker, float damage, double motionX, double motionZ, double multiplier) {
        double resistance = living.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE);
        if (living.getRandom().nextDouble() >= resistance) {
            living.hasImpulse = true;
            double horizontal = Math.sqrt(motionX * motionX + motionZ * motionZ);
            double magnitude = 0.4 * multiplier;
            Vec3 current = living.getDeltaMovement();
            Vec3 modified = new Vec3(current.x * 0.5 - motionX / horizontal * magnitude, current.y * 0.5 + magnitude, current.z * 0.5 - motionZ / horizontal * magnitude);
            if (modified.y > 0.2 * multiplier) {
                modified = new Vec3(modified.x, 0.2 * multiplier, modified.z);
            }
            living.setDeltaMovement(modified);
        }
    }

    public static void damageArmorNT(LivingEntity entity, float amount) {
    }
}

