/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.util.i18n;

import com.hbm.util.i18n.ITranslate;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class I18nClient
implements ITranslate {
    @Override
    public String resolveKey(String s, Object ... args) {
        return I18n.get((String)s, (Object[])args);
    }

    @Override
    public String[] resolveKeyArray(String s, Object ... args) {
        return this.resolveKey(s, args).split("\\$");
    }

    @Override
    public List<String> autoBreakWithParagraphs(Object fontRenderer, String text, int width) {
        String[] paragraphs = text.split("\\$");
        ArrayList<String> lines = new ArrayList<String>();
        for (String paragraph : paragraphs) {
            lines.addAll(this.autoBreak(fontRenderer, paragraph, width));
        }
        return lines;
    }

    @Override
    public List<String> autoBreak(Object o, String text, int width) {
        Font font = (Font)o;
        ArrayList<String> result = new ArrayList<String>();
        String[] words = text.split(" ");
        if (words.length == 0) {
            return result;
        }
        StringBuilder currentLine = new StringBuilder(words[0]);
        int indent = font.width((FormattedText)Component.literal((String)words[0]));
        for (int w = 1; w < words.length; ++w) {
            int wordWidth = font.width((FormattedText)Component.literal((String)(" " + words[w])));
            if (indent + wordWidth <= width) {
                currentLine.append(" ").append(words[w]);
                indent += wordWidth;
                continue;
            }
            result.add(currentLine.toString());
            currentLine = new StringBuilder(words[w]);
            indent = font.width((FormattedText)Component.literal((String)words[w]));
        }
        result.add(currentLine.toString());
        return result;
    }

    private static String sequenceToString(FormattedCharSequence seq) {
        StringBuilder sb = new StringBuilder();
        seq.accept((index, style, codePoint) -> {
            sb.appendCodePoint(codePoint);
            return true;
        });
        return sb.toString();
    }
}

