/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.util.i18n;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;

public class I18nUtil {
    public static String resolveKey(String key, Object ... args) {
        return I18n.get((String)key, (Object[])args);
    }

    public static String format(String key, Object ... args) {
        return I18n.get((String)key, (Object[])args);
    }

    public static String[] resolveKeyArray(String key, Object ... args) {
        return I18n.get((String)key, (Object[])args).split("\\$");
    }

    public static List<String> autoBreakWithParagraphs(Object fontRenderer, String text, int width) {
        if (fontRenderer instanceof Font) {
            String[] paragraphs;
            Font font = (Font)fontRenderer;
            ArrayList<String> result = new ArrayList<String>();
            for (String paragraph : paragraphs = text.split("\\$")) {
                List lines = font.split((FormattedText)Component.literal((String)paragraph), width);
                for (FormattedCharSequence seq : lines) {
                    StringBuilder sb = new StringBuilder();
                    seq.accept((index, style, codePoint) -> {
                        sb.appendCodePoint(codePoint);
                        return true;
                    });
                    result.add(sb.toString());
                }
            }
            return result;
        }
        return List.of(text);
    }

    public static List<String> autoBreak(Object fontRenderer, String text, int width) {
        if (fontRenderer instanceof Font) {
            Font font = (Font)fontRenderer;
            List lines = font.split((FormattedText)Component.literal((String)text), width);
            return lines.stream().map(seq -> {
                StringBuilder sb = new StringBuilder();
                seq.accept((index, style, codePoint) -> {
                    sb.appendCodePoint(codePoint);
                    return true;
                });
                return sb.toString();
            }).toList();
        }
        return List.of(text);
    }
}

