/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.wiaj;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public class WorldInAJar
implements BlockAndTintGetter {
    public final int sizeX;
    public final int sizeY;
    public final int sizeZ;
    private BlockState[][][] blocks;
    private BlockEntity[][][] be;

    public WorldInAJar(int x, int y, int z) {
        this.sizeX = x;
        this.sizeY = y;
        this.sizeZ = z;
        this.blocks = new BlockState[x][y][z];
        this.be = new BlockEntity[x][y][z];
    }

    public void nuke() {
        this.blocks = new BlockState[this.sizeX][this.sizeY][this.sizeZ];
        this.be = new BlockEntity[this.sizeX][this.sizeY][this.sizeZ];
    }

    public BlockState getBlock(int x, int y, int z) {
        if (x < 0 || x >= this.sizeX || y < 0 || y >= this.sizeY || z < 0 || z >= this.sizeZ) {
            return Blocks.AIR.defaultBlockState();
        }
        return this.blocks[x][y][z] != null ? this.blocks[x][y][z] : Blocks.AIR.defaultBlockState();
    }

    public void setBlock(int x, int y, int z, BlockState state) {
        if (x < 0 || x >= this.sizeX || y < 0 || y >= this.sizeY || z < 0 || z >= this.sizeZ) {
            return;
        }
        this.blocks[x][y][z] = state;
    }

    public void setBlockEntity(int x, int y, int z, BlockEntity blockEntity) {
        if (x < 0 || x >= this.sizeX || y < 0 || y >= this.sizeY || z < 0 || z >= this.sizeZ) {
            return;
        }
        this.be[x][y][z] = blockEntity;
    }

    public BlockState getBlockState(BlockPos pos) {
        return this.getBlock(pos.getX(), pos.getY(), pos.getZ());
    }

    public BlockEntity getBlockEntity(BlockPos pos) {
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        if (x < 0 || x >= this.sizeX || y < 0 || y >= this.sizeY || z < 0 || z >= this.sizeZ) {
            return null;
        }
        return this.be[x][y][z];
    }

    public FluidState getFluidState(BlockPos pos) {
        return Fluids.EMPTY.defaultFluidState();
    }

    public int getBrightness(LightLayer type, BlockPos pos) {
        return 15;
    }

    public int getRawBrightness(BlockPos pos, int ambientDarkening) {
        return 15;
    }

    public boolean isAirBlock(int x, int y, int z) {
        return this.getBlock(x, y, z).isAir();
    }

    public int getHeight() {
        return this.sizeY;
    }

    public int getMinBuildHeight() {
        return 0;
    }

    public float getShade(Direction dir, boolean ambient) {
        ClientLevel lvl = Minecraft.getInstance().level;
        return lvl == null ? 1.0f : lvl.getShade(dir, ambient);
    }

    public LevelLightEngine getLightEngine() {
        ClientLevel lvl = Minecraft.getInstance().level;
        return lvl == null ? null : lvl.getLightEngine();
    }

    public int getBlockTint(BlockPos pos, ColorResolver resolver) {
        Biome plains = (Biome)Minecraft.getInstance().level.registryAccess().registryOrThrow(Registries.BIOME).getOrThrow(Biomes.PLAINS);
        return resolver.getColor(plains, (double)pos.getX(), (double)pos.getZ());
    }
}

