/*
 * Decompiled with CFR 0.152.
 */
package com.hbm;

import com.hbm.HBMsNTM;
import com.hbm.blocks.ModBlocks;
import com.hbm.commands.LivingPropsCommand;
import com.hbm.commands.SatellitesCommand;
import com.hbm.config.FalloutConfigJSON;
import com.hbm.config.MainConfig;
import com.hbm.entity.ModEntities;
import com.hbm.entity.mob.CreeperNuclear;
import com.hbm.entity.mob.Duck;
import com.hbm.handler.EntityEffectHandler;
import com.hbm.handler.HTTPHandler;
import com.hbm.handler.HazmatRegistry;
import com.hbm.hazard.HazardRegistry;
import com.hbm.hazard.HazardSystem;
import com.hbm.inventory.ModMenuTypes;
import com.hbm.inventory.screens.MachineSatLinkerScreen;
import com.hbm.items.ModItems;
import com.hbm.saveddata.satellite.Satellite;
import com.hbm.util.ArmorUtil;
import com.hbm.util.DamageResistanceHandler;
import com.mojang.brigadier.CommandDispatcher;
import java.io.File;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

@EventBusSubscriber(modid="hbmsntm")
public class CommonEvents {
    public static File configDir;
    public static File configHbmDir;

    @SubscribeEvent
    public static void commonSetup(FMLCommonSetupEvent event) {
        configDir = FMLPaths.CONFIGDIR.get().toFile();
        configHbmDir = new File(configDir, "hbmConfig");
        if (!configHbmDir.exists()) {
            configHbmDir.mkdirs();
        }
        HBMsNTM.LOGGER.info("Let us celebrate the fact that the logger finally works again!");
        HTTPHandler.loadStats();
        FalloutConfigJSON.initialize();
        DamageResistanceHandler.init();
        HazardRegistry.registerItems();
        HazmatRegistry.registerHazmats();
        ArmorUtil.register();
        Satellite.register();
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (((Boolean)MainConfig.COMMON.ENABLE_MOTD.get()).booleanValue()) {
            Player player = event.getEntity();
            player.sendSystemMessage((Component)Component.translatable((String)"message.hbmsntm.loaded", (Object[])new Object[]{String.valueOf(ChatFormatting.YELLOW) + "0.0.6 ALPHA (5544)"}));
            if (HTTPHandler.newVersion) {
                player.sendSystemMessage((Component)Component.translatable((String)"message.hbmsntm.new_version", (Object[])new Object[]{HTTPHandler.versionNumber}).withStyle(Style.EMPTY.withColor(ChatFormatting.YELLOW)).append((Component)Component.translatable((String)"message.hbmsntm.click_here").withStyle(Style.EMPTY.withColor(ChatFormatting.RED).withUnderlined(Boolean.valueOf(true)).withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://github.com/ohiomannnn/HBMsNTM-NEO-EDITION/releases")))).append((Component)Component.translatable((String)"message.hbmsntm.to_download").withStyle(Style.EMPTY.withColor(ChatFormatting.YELLOW))));
            }
        }
    }

    @SubscribeEvent
    public static void onEntityAttributeCreation(EntityAttributeCreationEvent event) {
        event.put((EntityType)ModEntities.DUCK.get(), Duck.createAttributes().build());
        event.put((EntityType)ModEntities.CREEPER_NUCLEAR.get(), CreeperNuclear.createAttributes().build());
    }

    @SubscribeEvent
    public static void onLivingTick(EntityTickEvent.Pre event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            HazardSystem.updatePlayerInventory(player);
        }
        if (entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            HazardSystem.updateDroppedItem(itemEntity);
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            HazardSystem.updateLivingInventory(livingEntity);
            EntityEffectHandler.tick(livingEntity);
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        BlockPos pos = event.getPos();
        Level level = (Level)event.getLevel();
        if (!(level.isClientSide || event.getState() != Blocks.COAL_ORE.defaultBlockState() && event.getState() != Blocks.DEEPSLATE_COAL_ORE.defaultBlockState() && event.getState() != Blocks.COAL_BLOCK.defaultBlockState())) {
            for (Direction dir : Direction.values()) {
                BlockPos offsetPos = pos.relative(dir);
                if (level.random.nextInt(2) != 0 || !level.getBlockState(offsetPos).isAir()) continue;
                level.setBlock(offsetPos, ((Block)ModBlocks.GAS_COAL.get()).defaultBlockState(), 3);
            }
        }
    }

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        LivingPropsCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        SatellitesCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void registerScreens(RegisterMenuScreensEvent event) {
        event.register((MenuType)ModMenuTypes.SAT_LINKER.get(), MachineSatLinkerScreen::new);
    }

    @SubscribeEvent
    public static void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.COMBAT) {
            event.accept(ModItems.ALLOY_SWORD);
            event.accept(ModItems.ALLOY_HELMET);
            event.accept(ModItems.ALLOY_CHESTPLATE);
            event.accept(ModItems.ALLOY_LEGGINGS);
            event.accept(ModItems.ALLOY_BOOTS);
        }
    }
}

