/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blockentity.bomb;

import com.hbm.blockentity.ModBlockEntities;
import com.hbm.blocks.bomb.LandmineBlock;
import com.hbm.lib.ModSounds;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class LandMineBlockEntity
extends BlockEntity {
    private boolean isPrimed = false;
    private boolean waitingForPlayer = false;

    public LandMineBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.LANDMINE.get(), pos, blockState);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, LandMineBlockEntity blockEntity) {
        Block block = state.getBlock();
        if (!(block instanceof LandmineBlock)) {
            return;
        }
        LandmineBlock landmine = (LandmineBlock)block;
        double range = landmine.range;
        double height = landmine.height;
        if (blockEntity.waitingForPlayer) {
            range = 25.0;
            height = 25.0;
        } else if (!blockEntity.isPrimed) {
            range *= 2.0;
            height *= 2.0;
        }
        if (!level.isEmptyBlock(pos.above())) {
            return;
        }
        List entities = level.getEntities(null, new AABB((double)pos.getX() - range, (double)pos.getY() - height, (double)pos.getZ() - range, (double)pos.getX() + range + 1.0, (double)pos.getY() + height, (double)pos.getZ() + range + 1.0));
        for (Entity entity : entities) {
            if (entity.getType().getCategory() == MobCategory.WATER_CREATURE || entity.getType().getCategory() == MobCategory.AMBIENT) continue;
            if (blockEntity.waitingForPlayer) {
                if (!(entity instanceof Player)) continue;
                blockEntity.waitingForPlayer = false;
                return;
            }
            if (!(entity instanceof LivingEntity)) continue;
            if (blockEntity.isPrimed) {
                landmine.explode(level, pos);
            }
            return;
        }
        if (!blockEntity.isPrimed && !blockEntity.waitingForPlayer) {
            level.playSound(null, pos, (SoundEvent)ModSounds.FSTBMB_START.get(), SoundSource.BLOCKS, 3.0f, 1.0f);
            blockEntity.isPrimed = true;
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.isPrimed = tag.getBoolean("Primed");
        this.waitingForPlayer = tag.getBoolean("Waiting");
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putBoolean("Primed", this.isPrimed);
        tag.putBoolean("Waiting", this.waitingForPlayer);
    }
}

