/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blockentity.machine;

import com.hbm.blockentity.ModBlockEntities;
import com.hbm.blocks.machine.GeigerCounterBlock;
import com.hbm.handler.radiation.ChunkRadiationManager;
import com.hbm.lib.ModSounds;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class GeigerBlockEntity
extends BlockEntity {
    public GeigerBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.GEIGER_COUNTER.get(), pos, blockState);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, GeigerBlockEntity blockEntity) {
        Block block = state.getBlock();
        if (!(block instanceof GeigerCounterBlock)) {
            return;
        }
        GeigerCounterBlock geiger = (GeigerCounterBlock)block;
        if (level.isClientSide) {
            return;
        }
        ++geiger.timer;
        if (geiger.timer == 10) {
            geiger.timer = 0;
            geiger.ticker = ChunkRadiationManager.proxy.getRadiation(level, pos);
            level.updateNeighborsAt(pos, state.getBlock());
        }
        if (level.getGameTime() % 5L == 0L) {
            if ((double)geiger.ticker > 1.0E-5) {
                int r;
                ArrayList<Integer> list = new ArrayList<Integer>();
                if (geiger.ticker < 1.0f) {
                    list.add(0);
                }
                if (geiger.ticker < 5.0f) {
                    list.add(0);
                }
                if (geiger.ticker < 10.0f) {
                    list.add(1);
                }
                if (geiger.ticker > 5.0f && geiger.ticker < 15.0f) {
                    list.add(2);
                }
                if (geiger.ticker > 10.0f && geiger.ticker < 20.0f) {
                    list.add(3);
                }
                if (geiger.ticker > 15.0f && geiger.ticker < 25.0f) {
                    list.add(4);
                }
                if (geiger.ticker > 20.0f && geiger.ticker < 30.0f) {
                    list.add(5);
                }
                if (geiger.ticker > 25.0f) {
                    list.add(6);
                }
                if ((r = ((Integer)list.get(geiger.rand.nextInt(list.size()))).intValue()) > 0) {
                    switch (r) {
                        case 1: {
                            GeigerBlockEntity.playSnd(level, pos, (SoundEvent)ModSounds.GEIGER1.get());
                            break;
                        }
                        case 2: {
                            GeigerBlockEntity.playSnd(level, pos, (SoundEvent)ModSounds.GEIGER2.get());
                            break;
                        }
                        case 3: {
                            GeigerBlockEntity.playSnd(level, pos, (SoundEvent)ModSounds.GEIGER3.get());
                            break;
                        }
                        case 4: {
                            GeigerBlockEntity.playSnd(level, pos, (SoundEvent)ModSounds.GEIGER4.get());
                            break;
                        }
                        case 5: {
                            GeigerBlockEntity.playSnd(level, pos, (SoundEvent)ModSounds.GEIGER5.get());
                            break;
                        }
                        case 6: {
                            GeigerBlockEntity.playSnd(level, pos, (SoundEvent)ModSounds.GEIGER6.get());
                        }
                    }
                }
            } else if (geiger.rand.nextInt(50) == 0) {
                GeigerBlockEntity.playSoundRand(level, pos, 1 + geiger.rand.nextInt(1));
            }
        }
    }

    protected static void playSnd(Level level, BlockPos pos, SoundEvent soundEvent) {
        level.playSound(null, pos, soundEvent, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    protected static void playSoundRand(Level level, BlockPos pos, int i) {
        switch (i) {
            case 1: {
                level.playSound(null, pos, (SoundEvent)ModSounds.GEIGER1.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                break;
            }
            case 2: {
                level.playSound(null, pos, (SoundEvent)ModSounds.GEIGER2.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }
}

