/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blockentity.machine;

import com.hbm.HBMsNTM;
import com.hbm.blockentity.LoadedBaseBlockEntity;
import com.hbm.items.ModItems;
import com.hbm.items.tools.KeyItem;
import com.hbm.lib.ModSounds;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class LockableBaseBlockEntity
extends LoadedBaseBlockEntity {
    protected int lock;
    private boolean isLocked = false;
    protected double lockMod = 0.1;

    public LockableBaseBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public void lock() {
        if (this.lock == 0) {
            HBMsNTM.LOGGER.error("A block has been set to locked state before setting pins, this should not happen and may cause errors! {}", (Object)this);
        }
        this.isLocked = true;
        this.setChanged();
    }

    public void setPins(int pins) {
        this.lock = pins;
        this.setChanged();
    }

    public int getPins() {
        return this.lock;
    }

    public void setMod(double mod) {
        this.lockMod = mod;
        this.setChanged();
    }

    public double getMod() {
        return this.lockMod;
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.lock = tag.getInt("lock");
        this.isLocked = tag.getBoolean("isLocked");
        this.lockMod = tag.getDouble("lockMod");
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("lock", this.lock);
        tag.putBoolean("isLocked", this.isLocked);
        tag.putDouble("lockMod", this.lockMod);
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeInt(this.lock);
        buf.writeBoolean(this.isLocked);
        buf.writeDouble(this.lockMod);
    }

    public boolean canAccess(Player player) {
        if (!this.isLocked) {
            return true;
        }
        if (player == null) {
            return false;
        }
        ItemStack stack = player.getMainHandItem();
        if (!stack.isEmpty() && stack.getItem() instanceof KeyItem && KeyItem.getPins(stack) == this.lock) {
            this.level.playSound(null, this.getBlockPos(), (SoundEvent)ModSounds.LOCK_OPEN.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        if (!stack.isEmpty() && stack.is((Item)ModItems.KEY_RED.get())) {
            this.level.playSound(null, this.getBlockPos(), (SoundEvent)ModSounds.LOCK_OPEN.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        return this.tryPick(player);
    }

    private boolean tryPick(Player player) {
        boolean canPick = false;
        ItemStack stack = player.getMainHandItem();
        double chanceOfSuccess = this.lockMod * 100.0;
        if (!stack.isEmpty() && stack.is((Item)ModItems.PIN.get()) && (player.getInventory().contains(new ItemStack((ItemLike)ModItems.SCREWDRIVER.get())) || player.getInventory().contains(new ItemStack((ItemLike)ModItems.SCREWDRIVER_DESH.get())))) {
            stack.shrink(1);
            canPick = true;
        }
        if (!stack.isEmpty() && (stack.is((Item)ModItems.SCREWDRIVER.get()) || stack.is((Item)ModItems.SCREWDRIVER_DESH.get())) && player.getInventory().contains(new ItemStack((ItemLike)ModItems.PIN.get()))) {
            this.removeOne(player, (Item)ModItems.PIN.get());
            canPick = true;
        }
        if (canPick) {
            double rand = player.level().random.nextDouble() * 100.0;
            if (chanceOfSuccess > rand) {
                this.level.playSound(null, this.getBlockPos(), (SoundEvent)ModSounds.PIN_UNLOCK.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                return true;
            }
            this.level.playSound(null, this.getBlockPos(), (SoundEvent)ModSounds.PIN_BREAK.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return false;
    }

    private void removeOne(Player player, Item item) {
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack invStack = player.getInventory().getItem(i);
            if (!invStack.is(item)) continue;
            invStack.shrink(1);
            return;
        }
    }
}

