/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.bomb;

import com.hbm.blockentity.bomb.CrashedBombBlockEntity;
import com.hbm.blocks.ModBlocks;
import com.hbm.config.MainConfig;
import com.hbm.entity.ModEntities;
import com.hbm.entity.logic.NukeExplosionBalefire;
import com.hbm.entity.logic.NukeExplosionMK5;
import com.hbm.explosion.vanillant.ExplosionVNT;
import com.hbm.explosion.vanillant.standard.BlockAllocatorStandard;
import com.hbm.explosion.vanillant.standard.BlockProcessorStandard;
import com.hbm.explosion.vanillant.standard.EntityProcessorCross;
import com.hbm.explosion.vanillant.standard.PlayerProcessorStandard;
import com.hbm.interfaces.IBomb;
import com.hbm.items.special.PolaroidItem;
import com.hbm.lib.ModSounds;
import com.hbm.network.toclient.AuxParticle;
import com.hbm.particle.helper.ExplosionCreator;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.PacketDistributor;

public class CrashedBombBlock
extends BaseEntityBlock
implements IBomb {
    public static final MapCodec<CrashedBombBlock> CODEC = CrashedBombBlock.simpleCodec(CrashedBombBlock::new);

    public CrashedBombBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        if (this == ModBlocks.CRASHED_BOMB_BALEFIRE.get()) {
            return CrashedBombBlockEntity.balefire(blockPos, blockState);
        }
        if (this == ModBlocks.CRASHED_BOMB_CONVENTIONAL.get()) {
            return CrashedBombBlockEntity.conventional(blockPos, blockState);
        }
        if (this == ModBlocks.CRASHED_BOMB_NUKE.get()) {
            return CrashedBombBlockEntity.nuke(blockPos, blockState);
        }
        if (this == ModBlocks.CRASHED_BOMB_SALTED.get()) {
            return CrashedBombBlockEntity.salted(blockPos, blockState);
        }
        return null;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return level.isClientSide ? null : (lvl, pos, st, be) -> {
            if (be instanceof CrashedBombBlockEntity) {
                CrashedBombBlockEntity bomb = (CrashedBombBlockEntity)be;
                CrashedBombBlockEntity.serverTick(lvl, pos, st, bomb);
            }
        };
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    @Override
    public IBomb.BombReturnCode explode(Level level, BlockPos pos) {
        if (!level.isClientSide) {
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
            if (this == ModBlocks.CRASHED_BOMB_BALEFIRE.get()) {
                NukeExplosionBalefire balefire = new NukeExplosionBalefire((EntityType)ModEntities.NUKE_BALEFIRE.get(), level);
                balefire.setPos(pos.getX(), pos.getY(), pos.getZ());
                balefire.destructionRange = (int)((double)((Integer)MainConfig.COMMON.FATMAN_RADIUS.get()).intValue() * 1.25);
                level.addFreshEntity((Entity)balefire);
                CrashedBombBlock.spawnMush(level, pos, true);
            }
            if (this == ModBlocks.CRASHED_BOMB_CONVENTIONAL.get()) {
                ExplosionVNT vnt = new ExplosionVNT(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 35.0f).setBlockAllocator(new BlockAllocatorStandard(24)).setBlockProcessor(new BlockProcessorStandard().setNoDrop()).setEntityProcessor(new EntityProcessorCross(5.0).withRangeMod(1.5f)).setPlayerProcessor(new PlayerProcessorStandard());
                ExplosionCreator.composeEffectLarge(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
                vnt.explode();
            }
            if (this == ModBlocks.CRASHED_BOMB_NUKE.get()) {
                NukeExplosionMK5.statFac(level, 35, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
                CrashedBombBlock.spawnMush(level, pos, PolaroidItem.polaroidID == 11 || level.random.nextInt(100) == 0);
            }
            if (this == ModBlocks.CRASHED_BOMB_SALTED.get()) {
                NukeExplosionMK5.statFac(level, 25, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5).setMoreFallout(25);
                CrashedBombBlock.spawnMush(level, pos, PolaroidItem.polaroidID == 11 || level.random.nextInt(100) == 0);
            }
        }
        return IBomb.BombReturnCode.DETONATED;
    }

    public static void spawnMush(Level level, BlockPos pos, boolean balefire) {
        level.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, (SoundEvent)ModSounds.MUKE_EXPLOSION.get(), SoundSource.BLOCKS, 15.0f, 1.0f);
        CompoundTag tag = new CompoundTag();
        tag.putString("type", "muke");
        tag.putBoolean("balefire", balefire);
        PacketDistributor.sendToPlayersNear((ServerLevel)((ServerLevel)level), null, (double)((double)pos.getX() + 0.5), (double)((double)pos.getY() + 0.5), (double)((double)pos.getZ() + 0.5), (double)250.0, (CustomPacketPayload)new AuxParticle(tag, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

