/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.bomb;

import api.hbm.block.IFuckingExplode;
import com.hbm.blocks.generic.FlammableBlock;
import com.hbm.entity.item.EntityTNTPrimedBase;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public abstract class DetonatableBlock
extends FlammableBlock
implements IFuckingExplode {
    protected int popFuse;
    protected boolean detonateOnCollision;
    protected boolean detonateOnShot;

    public DetonatableBlock(BlockBehaviour.Properties properties, int encouragement, int flammability, int popFuse, boolean detonateOnCollision, boolean detonateOnShot) {
        super(properties, encouragement, flammability);
        this.popFuse = popFuse;
        this.detonateOnCollision = detonateOnCollision;
        this.detonateOnShot = detonateOnShot;
    }

    public void wasExploded(Level level, BlockPos pos, Explosion explosion) {
        if (!level.isClientSide) {
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
            EntityTNTPrimedBase tntPrimed = new EntityTNTPrimedBase(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, explosion.getIndirectSourceEntity(), this);
            tntPrimed.fuse = this.popFuse <= 0 ? 0 : level.random.nextInt(this.popFuse) + this.popFuse / 2;
            tntPrimed.detonateOnCollision = this.detonateOnCollision;
            level.addFreshEntity((Entity)tntPrimed);
        }
    }

    public boolean canDropFromExplosion(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        return false;
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        if (!level.isClientSide && this.shouldIgnite(level, pos)) {
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
            this.wasExploded(level, pos, null);
        }
    }

    public void onShot(Level level, BlockPos pos) {
        if (!this.detonateOnShot) {
            return;
        }
        level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
        this.explodeEntity(level, pos.getX(), pos.getY(), pos.getZ(), null);
    }
}

