/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.bomb;

import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.bomb.DetonatableBlock;
import com.hbm.config.MainConfig;
import com.hbm.entity.effect.NukeTorex;
import com.hbm.entity.item.EntityTNTPrimedBase;
import com.hbm.entity.logic.NukeExplosionMK5;
import com.hbm.explosion.vanillant.ExplosionVNT;
import com.hbm.explosion.vanillant.standard.BlockAllocatorStandard;
import com.hbm.explosion.vanillant.standard.BlockProcessorNoDamage;
import com.hbm.explosion.vanillant.standard.EntityProcessorStandard;
import com.hbm.explosion.vanillant.standard.PlayerProcessorStandard;
import com.hbm.interfaces.IBomb;
import com.hbm.particle.helper.ExplosionCreator;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class ExplosiveChargeBlock
extends DetonatableBlock
implements IBomb {
    public ExplosiveChargeBlock(BlockBehaviour.Properties properties) {
        super(properties, 0, 0, 0, false, false);
    }

    @Override
    public IBomb.BombReturnCode explode(Level level, BlockPos pos) {
        if (!level.isClientSide) {
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
            if (this == ModBlocks.DET_CHARGE.get()) {
                ExplosionVNT vnt = new ExplosionVNT(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 15.0f).setBlockAllocator(new BlockAllocatorStandard(64)).setBlockProcessor(new BlockProcessorNoDamage()).setEntityProcessor(new EntityProcessorStandard()).setPlayerProcessor(new PlayerProcessorStandard());
                ExplosionCreator.composeEffectStandard(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
                vnt.explode();
            }
            if (this == ModBlocks.DET_NUKE.get()) {
                NukeExplosionMK5.statFac(level, (Integer)MainConfig.COMMON.MISSLE_RADIUS.get(), (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
                NukeTorex.statFacStandard(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, ((Integer)MainConfig.COMMON.MISSLE_RADIUS.get()).intValue());
            }
        }
        return IBomb.BombReturnCode.DETONATED;
    }

    @Override
    public void explodeEntity(Level level, double x, double y, double z, EntityTNTPrimedBase entity) {
        this.explode(level, BlockPos.containing((double)x, (double)y, (double)z));
    }

    @Override
    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        if (level.hasNeighborSignal(pos)) {
            this.explode(level, pos);
        }
    }
}

