/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.bomb;

import com.hbm.blockentity.ModBlockEntities;
import com.hbm.blockentity.bomb.LandMineBlockEntity;
import com.hbm.blocks.ModBlocks;
import com.hbm.config.MainConfig;
import com.hbm.explosion.ExplosionLarge;
import com.hbm.explosion.ExplosionNukeGeneric;
import com.hbm.explosion.vanillant.ExplosionVNT;
import com.hbm.explosion.vanillant.standard.BlockAllocatorStandard;
import com.hbm.explosion.vanillant.standard.BlockAllocatorWater;
import com.hbm.explosion.vanillant.standard.BlockProcessorStandard;
import com.hbm.explosion.vanillant.standard.EntityProcessorCrossSmooth;
import com.hbm.explosion.vanillant.standard.ExplosionEffectWeapon;
import com.hbm.explosion.vanillant.standard.PlayerProcessorStandard;
import com.hbm.interfaces.IBomb;
import com.hbm.items.special.PolaroidItem;
import com.hbm.lib.ModSounds;
import com.hbm.network.toclient.AuxParticle;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.network.PacketDistributor;

public class LandmineBlock
extends BaseEntityBlock
implements IBomb {
    private static final VoxelShape SHAPE_AP = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)1.0, (double)11.0);
    private static final VoxelShape SHAPE_HE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0);
    private static final VoxelShape SHAPE_SHRAP = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)1.0, (double)11.0);
    private static final VoxelShape SHAPE_FAT = Block.box((double)5.0, (double)0.0, (double)4.0, (double)11.0, (double)6.0, (double)12.0);
    public static boolean safeMode = false;
    public double range;
    public double height;
    public static final MapCodec<LandmineBlock> CODEC = LandmineBlock.simpleCodec(LandmineBlock::new);

    protected LandmineBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public LandmineBlock(BlockBehaviour.Properties properties, double range, double height) {
        this(properties);
        this.range = range;
        this.height = height;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new LandMineBlockEntity(blockPos, blockState);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return level.isClientSide ? null : BaseEntityBlock.createTickerHelper(type, ModBlockEntities.LANDMINE.get(), LandMineBlockEntity::serverTick);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (this == ModBlocks.MINE_AP.get()) {
            return SHAPE_AP;
        }
        if (this == ModBlocks.MINE_HE.get()) {
            return SHAPE_HE;
        }
        if (this == ModBlocks.MINE_SHRAP.get()) {
            return SHAPE_SHRAP;
        }
        if (this == ModBlocks.MINE_FAT.get()) {
            return SHAPE_FAT;
        }
        return Shapes.block();
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.getShape(state, level, pos, context);
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        if (!level.isClientSide) {
            BlockPos below;
            if (level.hasNeighborSignal(pos)) {
                this.explode(level, pos);
            }
            if (!level.getBlockState(below = pos.below()).isFaceSturdy((BlockGetter)level, below, Direction.UP)) {
                if (!safeMode) {
                    this.explode(level, pos);
                } else {
                    level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
                }
            }
        }
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos below = pos.below();
        if (level.getBlockState(below).is(BlockTags.LEAVES)) {
            return false;
        }
        if (level.getBlockState(below).getBlock() instanceof LandmineBlock) {
            return false;
        }
        return level.getBlockState(below).isFaceSturdy((BlockGetter)level, below, Direction.UP);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (!safeMode) {
            this.explode(level, pos);
        } else {
            Block.dropResources((BlockState)state, (Level)level, (BlockPos)pos);
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    @Override
    public IBomb.BombReturnCode explode(Level level, BlockPos pos) {
        if (!level.isClientSide) {
            ServerLevel serverLevel;
            ExplosionVNT vnt;
            safeMode = true;
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
            safeMode = false;
            if (this == ModBlocks.MINE_AP.get()) {
                vnt = new ExplosionVNT(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 3.0f).setEntityProcessor(new EntityProcessorCrossSmooth(0.5, (float)MainConfig.SERVER.MINE_AP_DAMAGE.getAsDouble()).setupPiercing(5.0f, 0.2f)).setPlayerProcessor(new PlayerProcessorStandard()).setSFX(new ExplosionEffectWeapon(5, 1.0f, 0.5f));
                vnt.explode();
            }
            if (this == ModBlocks.MINE_HE.get()) {
                vnt = new ExplosionVNT(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 4.0f).setBlockAllocator(new BlockAllocatorStandard()).setBlockProcessor(new BlockProcessorStandard()).setEntityProcessor(new EntityProcessorCrossSmooth(1.0, (float)MainConfig.SERVER.MINE_HE_DAMAGE.getAsDouble()).setupPiercing(15.0f, 0.2f)).setPlayerProcessor(new PlayerProcessorStandard()).setSFX(new ExplosionEffectWeapon(15, 3.5f, 1.25f));
                vnt.explode();
            }
            if (this == ModBlocks.MINE_SHRAP.get()) {
                vnt = new ExplosionVNT(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 3.0f).setEntityProcessor(new EntityProcessorCrossSmooth(0.5, (float)MainConfig.SERVER.MINE_SHRAP_DAMAGE.getAsDouble())).setPlayerProcessor(new PlayerProcessorStandard()).setSFX(new ExplosionEffectWeapon(5, 1.0f, 0.5f));
                vnt.explode();
                if (level instanceof ServerLevel) {
                    serverLevel = (ServerLevel)level;
                    ExplosionLarge.spawnShrapnelShower(serverLevel, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 0.0, 1.0, 0.0, 45, 0.2);
                    ExplosionLarge.spawnShrapnels(serverLevel, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 5);
                }
            }
            if (this == ModBlocks.MINE_FAT.get()) {
                vnt = new ExplosionVNT(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 10.0f).setBlockAllocator(new BlockAllocatorStandard(64)).setBlockProcessor(new BlockProcessorStandard()).setEntityProcessor(new EntityProcessorCrossSmooth(2.0, (float)MainConfig.SERVER.MINE_NUKE_DAMAGE.getAsDouble()).withRangeMod(1.5f)).setPlayerProcessor(new PlayerProcessorStandard());
                vnt.explode();
                ExplosionNukeGeneric.incrementRad(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 1.5f);
                level.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, (SoundEvent)ModSounds.MUKE_EXPLOSION.get(), SoundSource.BLOCKS, 25.0f, 0.9f);
                CompoundTag tag = new CompoundTag();
                tag.putString("type", "muke");
                tag.putBoolean("balefire", PolaroidItem.polaroidID == 11 || level.random.nextInt(100) == 0);
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel2 = (ServerLevel)level;
                    PacketDistributor.sendToPlayersNear((ServerLevel)serverLevel2, null, (double)((double)pos.getX() + 0.5), (double)((double)pos.getY() + 0.5), (double)((double)pos.getZ() + 0.5), (double)250.0, (CustomPacketPayload)new AuxParticle(tag, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
            if (this == ModBlocks.MINE_NAVAL.get()) {
                vnt = new ExplosionVNT(level, pos.getX() + 5, pos.getY() + 5, pos.getZ() + 5, 25.0f).setBlockAllocator(new BlockAllocatorWater(32)).setBlockProcessor(new BlockProcessorStandard()).setEntityProcessor(new EntityProcessorCrossSmooth(0.5, (float)MainConfig.SERVER.MINE_NAVAL_DAMAGE.getAsDouble()).setupPiercing(5.0f, 0.2f)).setPlayerProcessor(new PlayerProcessorStandard()).setSFX(new ExplosionEffectWeapon(10, 1.0f, 0.5f));
                vnt.explode();
                if (level instanceof ServerLevel) {
                    serverLevel = (ServerLevel)level;
                    ExplosionLarge.spawnParticlesRadial(serverLevel, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 30);
                    ExplosionLarge.spawnRubble(serverLevel, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 5);
                    if (this.isWaterAbove(level, pos)) {
                        ExplosionLarge.spawnFoam(serverLevel, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 60);
                    }
                }
            }
        }
        return IBomb.BombReturnCode.DETONATED;
    }

    public boolean isWaterAbove(Level level, BlockPos pos) {
        for (int xo = -1; xo <= 1; ++xo) {
            for (int zo = -1; zo <= 1; ++zo) {
                if (!level.getFluidState(new BlockPos(pos.getX() + xo, pos.getY() + 1, pos.getZ() + zo)).is(FluidTags.WATER)) continue;
                return true;
            }
        }
        return false;
    }
}

