/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.bomb;

import com.hbm.lib.ModEffect;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TaintBlock
extends FallingBlock {
    public static final IntegerProperty TAINT_LEVEL = IntegerProperty.create((String)"taint_level", (int)0, (int)15);
    protected static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    public static final MapCodec<TaintBlock> CODEC = TaintBlock.simpleCodec(TaintBlock::new);

    public TaintBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)TAINT_LEVEL, (Comparable)Integer.valueOf(0)));
    }

    protected MapCodec<? extends FallingBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{TAINT_LEVEL});
    }

    public MapColor getMapColor(BlockState state, BlockGetter level, BlockPos pos, MapColor defaultColor) {
        return MapColor.COLOR_GRAY;
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int currentLevel = (Integer)state.getValue((Property)TAINT_LEVEL);
        if (currentLevel >= 15) {
            return;
        }
        for (int i = -3; i <= 3; ++i) {
            for (int j = -3; j <= 3; ++j) {
                for (int k = -3; k <= 3; ++k) {
                    BlockPos targetPos;
                    BlockState targetState;
                    if (Math.abs(i) + Math.abs(j) + Math.abs(k) > 4 || random.nextFloat() > 0.25f || (targetState = level.getBlockState(targetPos = pos.offset(i, j, k))).isAir() || targetState.is(Blocks.BEDROCK)) continue;
                    int newLevel = currentLevel + 1;
                    boolean hasAir = false;
                    for (Direction dir : Direction.values()) {
                        if (!level.getBlockState(targetPos.relative(dir)).isAir()) continue;
                        hasAir = true;
                        break;
                    }
                    if (!hasAir) {
                        newLevel = currentLevel + 3;
                    }
                    if (newLevel > 15 || targetState.is((Block)this) && (Integer)targetState.getValue((Property)TAINT_LEVEL) >= newLevel) continue;
                    level.setBlock(targetPos, (BlockState)this.defaultBlockState().setValue((Property)TAINT_LEVEL, (Comparable)Integer.valueOf(newLevel)), 3);
                }
            }
        }
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        int meta = (Integer)state.getValue((Property)TAINT_LEVEL);
        int potionLevel = 15 - meta;
        Vec3 motion = entity.getDeltaMovement();
        entity.setDeltaMovement(motion.x * 0.6, motion.y, motion.z * 0.6);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            MobEffectInstance effect = new MobEffectInstance(ModEffect.TAINT, 300, potionLevel);
            if (level.random.nextInt(50) == 0) {
                livingEntity.addEffect(effect);
            }
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.literal((String)"DO NOT TOUCH, BREATHE OR STARE AT.").withStyle(ChatFormatting.GRAY));
    }
}

