/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.gas;

import com.hbm.blocks.gas.GasBaseBlock;
import com.hbm.extprop.HbmLivingAttachments;
import com.hbm.util.ArmorRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class GasAsbestosBlock
extends GasBaseBlock {
    public GasAsbestosBlock(BlockBehaviour.Properties properties) {
        super(properties, 0.6f, 0.6f, 0.5f);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (level.random.nextInt(5) == 0) {
            level.addParticle((ParticleOptions)ParticleTypes.ASH, (double)((float)pos.getX() + random.nextFloat()), (double)((float)pos.getY() + random.nextFloat()), (double)((float)pos.getZ() + random.nextFloat()), 0.0, 0.0, 0.0);
        }
        super.animateTick(state, level, pos, random);
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        LivingEntity livingEntity;
        if (entity instanceof LivingEntity && !ArmorRegistry.hasProtection(livingEntity = (LivingEntity)entity, EquipmentSlot.HEAD, ArmorRegistry.HazardClass.PARTICLE_FINE)) {
            HbmLivingAttachments.incrementAsbestos(livingEntity, 1);
        }
    }

    @Override
    public Direction getFirstDirection(Level level, BlockPos pos) {
        if (level.getRandom().nextInt(5) == 0) {
            return Direction.DOWN;
        }
        return Direction.getRandom((RandomSource)level.getRandom());
    }

    @Override
    public Direction getSecondDirection(Level level, BlockPos pos) {
        return this.randomHorizontal(level.getRandom());
    }

    @Override
    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (random.nextInt(50) == 0) {
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
            return;
        }
        super.tick(state, level, pos, random);
    }
}

