/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.gas;

import com.hbm.HBMsNTMClient;
import com.hbm.util.ArmorUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public abstract class GasBaseBlock
extends Block {
    protected float red;
    protected float green;
    protected float blue;

    public GasBaseBlock(BlockBehaviour.Properties properties, float r, float g, float b) {
        super(properties);
        this.red = r;
        this.green = g;
        this.blue = b;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext context) {
        return true;
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!level.isClientSide()) {
            level.scheduleTick(pos, (Block)this, 10);
        }
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean isMoving) {
        if (!level.isClientSide()) {
            level.scheduleTick(pos, (Block)this, 10);
        }
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!this.tryMove(level, pos, this.getFirstDirection((Level)level, pos)) && !this.tryMove(level, pos, this.getSecondDirection((Level)level, pos))) {
            level.scheduleTick(pos, (Block)this, this.getDelay((LevelAccessor)level));
        }
    }

    public abstract Direction getFirstDirection(Level var1, BlockPos var2);

    public Direction getSecondDirection(Level level, BlockPos pos) {
        return this.getFirstDirection(level, pos);
    }

    public boolean tryMove(ServerLevel level, BlockPos pos, Direction dir) {
        BlockPos targetPos = pos.relative(dir);
        if (level.getBlockState(targetPos).isAir()) {
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 2);
            level.setBlock(targetPos, this.defaultBlockState(), 2);
            level.scheduleTick(targetPos, (Block)this, this.getDelay((LevelAccessor)level));
            return true;
        }
        return false;
    }

    public int getDelay(LevelAccessor levelAccessor) {
        return 2;
    }

    public Direction randomHorizontal(RandomSource random) {
        return Direction.Plane.HORIZONTAL.getRandomDirection(random);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (ArmorUtil.checkArmorPiece((LivingEntity)player, Items.GOLDEN_HELMET, EquipmentSlot.HEAD)) {
            CompoundTag tag = new CompoundTag();
            tag.putString("type", "vanillaExt");
            tag.putString("mode", "cloud");
            tag.putDouble("posX", (double)pos.getX() + 0.5);
            tag.putDouble("posY", (double)pos.getY() + 0.5);
            tag.putDouble("posZ", (double)pos.getZ() + 0.5);
            tag.putFloat("r", this.red);
            tag.putFloat("g", this.green);
            tag.putFloat("b", this.blue);
            HBMsNTMClient.effectNT(tag);
        }
    }
}

