/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.gas;

import com.hbm.blocks.gas.GasBaseBlock;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class GasFlammableBlock
extends GasBaseBlock {
    public static HashSet<Block> fireSources = new HashSet();

    public GasFlammableBlock(BlockBehaviour.Properties properties) {
        super(properties, 0.8f, 0.8f, 0.2f);
        if (fireSources.isEmpty()) {
            fireSources.add(Blocks.FIRE);
            fireSources.add(Blocks.LAVA);
            fireSources.add(Blocks.TORCH);
            fireSources.add(Blocks.JACK_O_LANTERN);
        }
    }

    @Override
    public Direction getFirstDirection(Level level, BlockPos pos) {
        if (level.random.nextInt(3) == 0) {
            return level.random.nextBoolean() ? Direction.DOWN : Direction.UP;
        }
        return this.randomHorizontal(level.getRandom());
    }

    @Override
    public Direction getSecondDirection(Level level, BlockPos pos) {
        return this.randomHorizontal(level.getRandom());
    }

    @Override
    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!level.isClientSide) {
            for (Direction dir : Direction.values()) {
                BlockPos checkPos = pos.relative(dir);
                Block b = level.getBlockState(checkPos).getBlock();
                if (!this.isFireSourceForGas(b)) continue;
                this.combust((Level)level, pos);
                return;
            }
            if (random.nextInt(20) == 0 && level.isEmptyBlock(pos.below())) {
                level.removeBlock(pos, false);
                return;
            }
        }
        super.tick(state, level, pos, random);
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (!level.isClientSide && entity.isOnFire()) {
            this.combust(level, pos);
        }
    }

    @Override
    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        for (Direction dir : Direction.values()) {
            BlockPos checkPos = pos.relative(dir);
            Block b = level.getBlockState(checkPos).getBlock();
            if (!this.isFireSourceForGas(b)) continue;
            level.scheduleTick(pos, (Block)this, 2);
        }
    }

    protected void combust(Level level, BlockPos pos) {
        level.setBlock(pos, Blocks.FIRE.defaultBlockState(), 3);
    }

    public boolean isFireSourceForGas(Block b) {
        return fireSources.contains(b);
    }

    public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return true;
    }

    @Override
    public int getDelay(LevelAccessor levelAccessor) {
        return levelAccessor.getRandom().nextInt(5) + 16;
    }
}

