/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.gas;

import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.gas.GasBaseBlock;
import com.hbm.extprop.HbmLivingAttachments;
import com.hbm.handler.radiation.ChunkRadiationManager;
import com.hbm.lib.ModEffect;
import com.hbm.util.ArmorRegistry;
import com.hbm.util.ArmorUtil;
import com.hbm.util.ContaminationUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class GasMeltdownBlock
extends GasBaseBlock {
    public GasMeltdownBlock(BlockBehaviour.Properties properties) {
        super(properties, 0.1f, 0.4f, 0.1f);
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            ContaminationUtil.contaminate(livingEntity, ContaminationUtil.HazardType.RADIATION, ContaminationUtil.ContaminationType.CREATIVE, 0.5f);
            livingEntity.addEffect(new MobEffectInstance(ModEffect.RADIATION, 1200, 2));
            if (ArmorRegistry.hasProtection(livingEntity, EquipmentSlot.HEAD, ArmorRegistry.HazardClass.PARTICLE_FINE)) {
                ArmorUtil.damageGasMaskFilter(livingEntity, 1);
            } else {
                HbmLivingAttachments.incrementAsbestos(livingEntity, 5);
            }
        }
    }

    @Override
    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.animateTick(state, level, pos, random);
        level.addParticle((ParticleOptions)ParticleTypes.MYCELIUM, (double)((float)pos.getX() + random.nextFloat()), (double)((float)pos.getY() + random.nextFloat()), (double)((float)pos.getZ() + random.nextFloat()), 0.0, 0.0, 0.0);
    }

    @Override
    public Direction getFirstDirection(Level level, BlockPos pos) {
        if (level.getRandom().nextInt(2) == 0) {
            return Direction.UP;
        }
        return Direction.DOWN;
    }

    @Override
    public Direction getSecondDirection(Level level, BlockPos pos) {
        return this.randomHorizontal(level.getRandom());
    }

    @Override
    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!level.isClientSide) {
            Direction dir = Direction.values()[random.nextInt(Direction.values().length)];
            BlockPos relative = pos.relative(dir);
            if (random.nextInt(7) == 0 && level.isEmptyBlock(relative)) {
                level.setBlock(pos, ((Block)ModBlocks.GAS_RADON_DENSE.get()).defaultBlockState(), 3);
            }
            if (level.canSeeSky(pos)) {
                ChunkRadiationManager.proxy.incrementRad((Level)level, pos, 5.0f);
            }
            if (random.nextInt(350) == 0) {
                level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
                return;
            }
        }
        super.tick(state, level, pos, random);
    }
}

