/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.gas;

import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.gas.GasBaseBlock;
import com.hbm.blocks.generic.FalloutBlock;
import com.hbm.extprop.HbmLivingAttachments;
import com.hbm.lib.ModEffect;
import com.hbm.util.ArmorRegistry;
import com.hbm.util.ArmorUtil;
import com.hbm.util.ContaminationUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class GasRadonDenseBlock
extends GasBaseBlock {
    public GasRadonDenseBlock(BlockBehaviour.Properties properties) {
        super(properties, 0.1f, 0.5f, 0.1f);
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (ArmorRegistry.hasProtection(livingEntity, EquipmentSlot.HEAD, ArmorRegistry.HazardClass.PARTICLE_FINE)) {
                ArmorUtil.damageGasMaskFilter(livingEntity, 1);
            } else {
                ContaminationUtil.contaminate(livingEntity, ContaminationUtil.HazardType.RADIATION, ContaminationUtil.ContaminationType.CREATIVE, 0.5f);
                livingEntity.addEffect(new MobEffectInstance(ModEffect.RADIATION, 300, 0));
                HbmLivingAttachments.incrementAsbestos(livingEntity, 5);
            }
        }
    }

    @Override
    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.animateTick(state, level, pos, random);
        level.addParticle((ParticleOptions)ParticleTypes.MYCELIUM, (double)((float)pos.getX() + random.nextFloat()), (double)((float)pos.getY() + random.nextFloat()), (double)((float)pos.getZ() + random.nextFloat()), 0.0, 0.0, 0.0);
    }

    @Override
    public Direction getFirstDirection(Level level, BlockPos pos) {
        if (level.getRandom().nextInt(2) == 0) {
            return Direction.UP;
        }
        return Direction.DOWN;
    }

    @Override
    public Direction getSecondDirection(Level level, BlockPos pos) {
        return this.randomHorizontal(level.getRandom());
    }

    @Override
    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!level.isClientSide) {
            if (random.nextInt(20) == 0 && level.getBlockState(pos.below()).is(Blocks.GRASS_BLOCK)) {
                level.setBlock(pos.below(), ((Block)ModBlocks.WASTE_EARTH.get()).defaultBlockState(), 3);
            }
            if (random.nextInt(30) == 0) {
                level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
                if (FalloutBlock.canPlaceBlockAt((Level)level, pos)) {
                    level.setBlock(pos, ((Block)ModBlocks.FALLOUT.get()).defaultBlockState(), 3);
                }
            }
        }
        super.tick(state, level, pos, random);
    }
}

