/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.gas;

import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.gas.GasBaseBlock;
import com.hbm.extprop.HbmLivingAttachments;
import com.hbm.lib.ModEffect;
import com.hbm.util.ContaminationUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class GasRadonTombBlock
extends GasBaseBlock {
    public GasRadonTombBlock(BlockBehaviour.Properties properties) {
        super(properties, 0.1f, 0.3f, 0.1f);
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.removeEffect(ModEffect.RADAWAY);
            livingEntity.removeEffect(ModEffect.RADX);
            ContaminationUtil.contaminate(livingEntity, ContaminationUtil.HazardType.RADIATION, ContaminationUtil.ContaminationType.RAD_BYPASS, 0.5f);
            HbmLivingAttachments.incrementAsbestos(livingEntity, 10);
        }
    }

    @Override
    public Direction getFirstDirection(Level level, BlockPos pos) {
        if (level.getRandom().nextInt(3) == 0) {
            return Direction.UP;
        }
        return Direction.DOWN;
    }

    @Override
    public Direction getSecondDirection(Level level, BlockPos pos) {
        return this.randomHorizontal(level.getRandom());
    }

    @Override
    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!level.isClientSide) {
            if (random.nextInt(10) == 0) {
                boolean removable;
                BlockPos below = pos.below();
                BlockState stateBelow = level.getBlockState(below);
                Block b = stateBelow.getBlock();
                if (b == Blocks.GRASS_BLOCK) {
                    if (random.nextInt(5) == 0) {
                        level.setBlock(below, Blocks.DIRT.defaultBlockState(), 3);
                    } else {
                        level.setBlock(below, ((Block)ModBlocks.WASTE_EARTH.get()).defaultBlockState(), 3);
                    }
                }
                boolean bl = removable = stateBelow.is(BlockTags.LEAVES) || stateBelow.is(BlockTags.REPLACEABLE) || stateBelow.is(BlockTags.MOSS_REPLACEABLE) || stateBelow.is(BlockTags.CLIMBABLE);
                if (removable && !stateBelow.isCollisionShapeFullBlock((BlockGetter)level, below)) {
                    level.removeBlock(below, false);
                }
            }
            if (random.nextInt(600) == 0) {
                level.removeBlock(pos, false);
                return;
            }
        }
        super.tick(state, level, pos, random);
    }
}

