/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.machine;

import com.hbm.blockentity.ModBlockEntities;
import com.hbm.blockentity.machine.GeigerBlockEntity;
import com.hbm.handler.radiation.ChunkRadiationManager;
import com.hbm.lib.ModSounds;
import com.hbm.util.ContaminationUtil;
import com.mojang.serialization.MapCodec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GeigerCounterBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING;
    public static final MapCodec<GeigerCounterBlock> CODEC;
    public int timer = 0;
    public float ticker = 0.0f;
    public Random rand = new Random();

    public GeigerCounterBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction dir = (Direction)blockState.getValue((Property)FACING);
        return switch (dir) {
            case Direction.WEST -> Block.box((double)2.0, (double)0.0, (double)1.5, (double)16.0, (double)9.0, (double)16.0);
            case Direction.EAST -> Block.box((double)0.0, (double)0.0, (double)0.0, (double)14.0, (double)9.0, (double)14.5);
            case Direction.SOUTH -> Block.box((double)1.5, (double)0.0, (double)0.0, (double)16.0, (double)9.0, (double)14.0);
            default -> Block.box((double)0.0, (double)0.0, (double)2.0, (double)14.5, (double)9.0, (double)16.0);
        };
    }

    public VoxelShape getCollisionShape(BlockState blockState, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.getShape(blockState, level, pos, context);
    }

    public boolean hasAnalogOutputSignal(BlockState blockState) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos pos) {
        float rad = ChunkRadiationManager.proxy.getRadiation(level, pos);
        return Math.min((int)Math.ceil(rad / 5.0f), 15);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return level.isClientSide ? null : BaseEntityBlock.createTickerHelper(type, ModBlockEntities.GEIGER_COUNTER.get(), GeigerBlockEntity::serverTick);
    }

    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new GeigerBlockEntity(blockPos, blockState);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!level.isClientSide) {
            level.playSound(null, pos, (SoundEvent)ModSounds.TECH_BOOP.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
            ContaminationUtil.printGeigerData(player);
        }
        return InteractionResult.SUCCESS;
    }

    static {
        CODEC = GeigerCounterBlock.simpleCodec(GeigerCounterBlock::new);
        FACING = HorizontalDirectionalBlock.FACING;
    }
}

