/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.machine;

import com.hbm.blockentity.ModBlockEntities;
import com.hbm.blockentity.machine.MachineSatLinkerBlockEntity;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class MachineSatLinkerBlock
extends BaseEntityBlock {
    public static final MapCodec<MachineSatLinkerBlock> CODEC = MachineSatLinkerBlock.simpleCodec(MachineSatLinkerBlock::new);

    public MapCodec<MachineSatLinkerBlock> codec() {
        return CODEC;
    }

    public MachineSatLinkerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            BlockEntity blockentity = level.getBlockEntity(pos);
            if (blockentity instanceof MachineSatLinkerBlockEntity) {
                MachineSatLinkerBlockEntity satLinkerBlockEntity = (MachineSatLinkerBlockEntity)blockentity;
                NonNullList stacks = NonNullList.create();
                for (int i = 0; i < satLinkerBlockEntity.getItems().getSlots(); ++i) {
                    stacks.add((Object)satLinkerBlockEntity.getItems().getStackInSlot(i));
                }
                if (level instanceof ServerLevel) {
                    Containers.dropContents((Level)level, (BlockPos)pos, (NonNullList)stacks);
                }
                super.onRemove(state, level, pos, newState, isMoving);
            } else {
                super.onRemove(state, level, pos, newState, isMoving);
            }
        }
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof MachineSatLinkerBlockEntity) {
            MachineSatLinkerBlockEntity entity = (MachineSatLinkerBlockEntity)blockEntity;
            if (!level.isClientSide) {
                player.openMenu((MenuProvider)new SimpleMenuProvider((MenuConstructor)entity, entity.getDisplayName()), pos);
            }
        }
        return ItemInteractionResult.SUCCESS;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new MachineSatLinkerBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return level.isClientSide ? null : BaseEntityBlock.createTickerHelper(type, ModBlockEntities.MACHINE_SATLINKER.get(), MachineSatLinkerBlockEntity::serverTick);
    }
}

