/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.commands;

import com.hbm.extprop.HbmLivingAttachments;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.BuiltInExceptions;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class LivingPropsCommand {
    private static final SimpleCommandExceptionType ERROR_NOT_LIVING = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.props.not_living"));
    private static final SuggestionProvider<CommandSourceStack> PROPS_SUGGESTIONS = (context, builder) -> {
        builder.suggest("radiation");
        builder.suggest("digamma");
        builder.suggest("asbestos");
        builder.suggest("blacklung");
        builder.suggest("oil");
        builder.suggest("fire");
        builder.suggest("phosphorus");
        builder.suggest("balefire");
        builder.suggest("blackfire");
        return builder.buildFuture();
    };

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"ntmprops").requires(src -> src.hasPermission(4))).then(Commands.literal((String)"get").then(Commands.argument((String)"target", (ArgumentType)EntityArgument.entity()).then(Commands.argument((String)"field", (ArgumentType)StringArgumentType.word()).suggests(PROPS_SUGGESTIONS).executes(LivingPropsCommand::getValue))))).then(Commands.literal((String)"set").then(Commands.argument((String)"target", (ArgumentType)EntityArgument.entity()).then(Commands.argument((String)"field", (ArgumentType)StringArgumentType.word()).suggests(PROPS_SUGGESTIONS).then(Commands.argument((String)"value", (ArgumentType)FloatArgumentType.floatArg()).executes(LivingPropsCommand::setValue))))));
    }

    private static LivingEntity getLiving(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Entity entity = EntityArgument.getEntity(context, (String)"target");
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return livingEntity;
        }
        throw ERROR_NOT_LIVING.create();
    }

    private static int getValue(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String field;
        LivingEntity target = LivingPropsCommand.getLiving(context);
        float value = switch (field = StringArgumentType.getString(context, (String)"field")) {
            case "radiation" -> HbmLivingAttachments.getRadiation(target);
            case "digamma" -> HbmLivingAttachments.getDigamma(target);
            case "asbestos" -> HbmLivingAttachments.getAsbestos(target);
            case "blacklung" -> HbmLivingAttachments.getBlackLung(target);
            case "oil" -> HbmLivingAttachments.getOil(target);
            case "fire" -> HbmLivingAttachments.getData((LivingEntity)target).fire;
            case "phosphorus" -> HbmLivingAttachments.getData((LivingEntity)target).phosphorus;
            case "balefire" -> HbmLivingAttachments.getData((LivingEntity)target).balefire;
            case "blackfire" -> HbmLivingAttachments.getData((LivingEntity)target).blackFire;
            default -> throw new BuiltInExceptions().dispatcherUnknownArgument().create();
        };
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"commands.props.get", (Object[])new Object[]{field, target.getName(), Float.valueOf(value)}), false);
        return 1;
    }

    private static int setValue(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        LivingEntity target = LivingPropsCommand.getLiving(context);
        String field = StringArgumentType.getString(context, (String)"field");
        float value = FloatArgumentType.getFloat(context, (String)"value");
        switch (field) {
            case "radiation": {
                HbmLivingAttachments.setRadiation(target, value);
                break;
            }
            case "digamma": {
                HbmLivingAttachments.setDigamma(target, value);
                break;
            }
            case "asbestos": {
                HbmLivingAttachments.setAsbestos(target, (int)value);
                break;
            }
            case "blacklung": {
                HbmLivingAttachments.setBlackLung(target, (int)value);
                break;
            }
            case "oil": {
                HbmLivingAttachments.setOil(target, (int)value);
                break;
            }
            case "fire": {
                HbmLivingAttachments.getData((LivingEntity)target).fire = (int)value;
                break;
            }
            case "phosphorus": {
                HbmLivingAttachments.getData((LivingEntity)target).phosphorus = (int)value;
                break;
            }
            case "balefire": {
                HbmLivingAttachments.getData((LivingEntity)target).balefire = (int)value;
                break;
            }
            case "blackfire": {
                HbmLivingAttachments.getData((LivingEntity)target).blackFire = (int)value;
                break;
            }
            default: {
                throw new BuiltInExceptions().dispatcherUnknownArgument().create();
            }
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"commands.props.set", (Object[])new Object[]{field, target.getName(), Float.valueOf(value)}), true);
        return 1;
    }
}

