/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.commands;

import com.hbm.items.ISatChip;
import com.hbm.saveddata.SatelliteSavedData;
import com.hbm.saveddata.satellite.Satellite;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class SatellitesCommand {
    private static final SuggestionProvider<CommandSourceStack> FREQ_SUGGESTIONS = (context, builder) -> {
        SatelliteSavedData data = SatelliteSavedData.get(((CommandSourceStack)context.getSource()).getLevel());
        data.sats.keySet().forEach(freq -> builder.suggest(String.valueOf(freq)));
        return builder.buildFuture();
    };

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"ntmsatellites").requires(src -> src.hasPermission(2))).then(Commands.literal((String)"orbit").executes(SatellitesCommand::orbit))).then(Commands.literal((String)"descend").then(Commands.argument((String)"frequency", (ArgumentType)IntegerArgumentType.integer()).suggests(FREQ_SUGGESTIONS).executes(SatellitesCommand::descend)))).then(Commands.literal((String)"list").executes(SatellitesCommand::listSatellites)));
    }

    private static int orbit(CommandContext<CommandSourceStack> context) {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
        if (player == null) {
            return 0;
        }
        ItemStack stack = player.getMainHandItem();
        if (!(stack.getItem() instanceof ISatChip)) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"commands.satellite.not_a_satellite"));
            return 0;
        }
        int id = Satellite.getIDFromItem(stack.getItem());
        int freq = ISatChip.getFreqS(stack);
        ServerLevel level = player.serverLevel();
        Satellite.orbit(level, id, freq, player.getX(), player.getY(), player.getZ());
        stack.shrink(1);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"commands.satellite.satellite_orbited"), false);
        return 1;
    }

    private static int descend(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerLevel level = source.getLevel();
        int freq = IntegerArgumentType.getInteger(context, (String)"frequency");
        SatelliteSavedData data = SatelliteSavedData.get(level);
        if (!data.sats.containsKey(freq)) {
            source.sendFailure((Component)Component.translatable((String)"commands.satellite.no_satellite"));
            return 0;
        }
        data.sats.remove(freq);
        data.setDirty();
        source.sendSuccess(() -> Component.translatable((String)"commands.satellite.satellite_descended"), true);
        return 1;
    }

    private static int listSatellites(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerLevel level = source.getLevel();
        SatelliteSavedData data = SatelliteSavedData.get(level);
        if (data.sats.isEmpty()) {
            source.sendFailure((Component)Component.translatable((String)"commands.satellite.no_active_satellites"));
            return 0;
        }
        data.sats.forEach((freq, sat) -> source.sendSuccess(() -> Component.literal((String)(freq + " - " + sat.getClass().getSimpleName())), false));
        return 1;
    }
}

