/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.config;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.CommonEvents;
import com.hbm.HBMsNTM;
import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.generic.SellafieldSlakedBlock;
import com.hbm.inventory.RecipesCommon;
import com.hbm.util.ModTags;
import com.hbm.util.Tuple;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class FalloutConfigJSON {
    public static final List<FalloutEntry> entries = new ArrayList<FalloutEntry>();
    public static Random rand = new Random();
    public static final Gson gson = new Gson();

    public static void initialize() {
        File folder = CommonEvents.configHbmDir;
        File config = new File(folder.getAbsolutePath() + File.separatorChar + "hbmFallout.json");
        File template = new File(folder.getAbsolutePath() + File.separatorChar + "_hbmFallout.json");
        FalloutConfigJSON.initDefault();
        if (!config.exists()) {
            FalloutConfigJSON.writeDefault(template);
        } else {
            List<FalloutEntry> conf = FalloutConfigJSON.readConfig(config);
            if (conf != null) {
                entries.clear();
                entries.addAll(conf);
            }
        }
    }

    public static void initDefault() {
        double woodEffectRange = 65.0;
        entries.add(new FalloutEntry().mT((TagKey<Block>)BlockTags.LOGS).prim(new Tuple.Pair<BlockState, Integer>(((Block)ModBlocks.WASTE_LOG.get()).defaultBlockState(), 1)).max(woodEffectRange));
        entries.add(new FalloutEntry().mBS(Blocks.MUSHROOM_STEM.defaultBlockState()).prim(new Tuple.Pair<BlockState, Integer>(((Block)ModBlocks.WASTE_LOG.get()).defaultBlockState(), 1)).max(woodEffectRange));
        entries.add(new FalloutEntry().mBS(Blocks.BROWN_MUSHROOM_BLOCK.defaultBlockState()).prim(new Tuple.Pair<BlockState, Integer>(Blocks.AIR.defaultBlockState(), 1)).max(woodEffectRange));
        entries.add(new FalloutEntry().mBS(Blocks.RED_MUSHROOM_BLOCK.defaultBlockState()).prim(new Tuple.Pair<BlockState, Integer>(Blocks.AIR.defaultBlockState(), 1)).max(woodEffectRange));
        entries.add(new FalloutEntry().mBS(Blocks.SNOW.defaultBlockState()).prim(new Tuple.Pair<BlockState, Integer>(Blocks.AIR.defaultBlockState(), 1)).max(woodEffectRange));
        entries.add(new FalloutEntry().mT((TagKey<Block>)BlockTags.PLANKS).prim(new Tuple.Pair<BlockState, Integer>(((Block)ModBlocks.WASTE_PLANKS.get()).defaultBlockState(), 1)).max(woodEffectRange));
        entries.add(new FalloutEntry().mT(ModTags.Blocks.LEAVES).prim(new Tuple.Pair<BlockState, Integer>(Blocks.AIR.defaultBlockState(), 1)).max(woodEffectRange));
        entries.add(new FalloutEntry().mBS(((Block)ModBlocks.WASTE_LEAVES.get()).defaultBlockState()).prim(new Tuple.Pair<BlockState, Integer>(Blocks.AIR.defaultBlockState(), 1)).max(woodEffectRange));
        entries.add(new FalloutEntry().mT((TagKey<Block>)BlockTags.CROPS).prim(new Tuple.Pair<BlockState, Integer>(Blocks.AIR.defaultBlockState(), 1)).max(woodEffectRange));
        entries.add(new FalloutEntry().mT((TagKey<Block>)BlockTags.FLOWERS).prim(new Tuple.Pair<BlockState, Integer>(Blocks.AIR.defaultBlockState(), 1)).max(woodEffectRange));
        entries.add(new FalloutEntry().mT((TagKey<Block>)BlockTags.SAPLINGS).prim(new Tuple.Pair<BlockState, Integer>(Blocks.AIR.defaultBlockState(), 1)).max(woodEffectRange));
        entries.add(new FalloutEntry().mT(ModTags.Blocks.LEAVES).prim(new Tuple.Pair<BlockState, Integer>(((Block)ModBlocks.WASTE_LEAVES.get()).defaultBlockState(), 1)).max(woodEffectRange + 100.0));
        entries.add(new FalloutEntry().mBS(Blocks.MOSSY_COBBLESTONE.defaultBlockState()).prim(new Tuple.Pair<BlockState, Integer>(Blocks.COAL_ORE.defaultBlockState(), 1)));
        entries.add(new FalloutEntry().mBS(((Block)ModBlocks.ORE_NETHER_URANIUM.get()).defaultBlockState()).prim(new Tuple.Pair<BlockState, Integer>(((Block)ModBlocks.ORE_NETHER_SCHRABIDIUM.get()).defaultBlockState(), 1), new Tuple.Pair<BlockState, Integer>(((Block)ModBlocks.ORE_NETHER_URANIUM_SCORCHED.get()).defaultBlockState(), 99)));
        for (int i = 1; i <= 10; ++i) {
            int m = 10 - i;
            entries.add(new FalloutEntry().prim(new Tuple.Pair<Object, Integer>(((Block)ModBlocks.ORE_SELLAFIELD_DIAMOND.get()).defaultBlockState().setValue((Property)SellafieldSlakedBlock.COLOR_LEVEL, (Comparable)Integer.valueOf(m)), 3), new Tuple.Pair<Object, Integer>(((Block)ModBlocks.ORE_SELLAFIELD_EMERALD.get()).defaultBlockState().setValue((Property)SellafieldSlakedBlock.COLOR_LEVEL, (Comparable)Integer.valueOf(m)), 2)).c(0.5).max(i * 5).sol(true).mBS(Blocks.COAL_ORE.defaultBlockState()));
            entries.add(new FalloutEntry().prim(new Tuple.Pair<Object, Integer>(((Block)ModBlocks.SELLAFIELD_BEDROCK.get()).defaultBlockState().setValue((Property)SellafieldSlakedBlock.COLOR_LEVEL, (Comparable)Integer.valueOf(m)), 1)).max(i * 5).sol(true).mBS(Blocks.BEDROCK.defaultBlockState()));
            entries.add(new FalloutEntry().prim(new Tuple.Pair<Object, Integer>(((Block)ModBlocks.SELLAFIELD_BEDROCK.get()).defaultBlockState().setValue((Property)SellafieldSlakedBlock.COLOR_LEVEL, (Comparable)Integer.valueOf(m)), 1)).max(i * 5).sol(true).mBS(((Block)ModBlocks.SELLAFIELD_BEDROCK.get()).defaultBlockState()));
            entries.add(new FalloutEntry().prim(new Tuple.Pair<Object, Integer>(((Block)ModBlocks.SELLAFIELD_SLAKED.get()).defaultBlockState().setValue((Property)SellafieldSlakedBlock.COLOR_LEVEL, (Comparable)Integer.valueOf(m)), 1)).max(i * 5).sol(true).mT(ModTags.Blocks.ACTUALLY_STONE));
            entries.add(new FalloutEntry().prim(new Tuple.Pair<Object, Integer>(((Block)ModBlocks.SELLAFIELD_SLAKED.get()).defaultBlockState().setValue((Property)SellafieldSlakedBlock.COLOR_LEVEL, (Comparable)Integer.valueOf(m)), 1)).max(i * 5).sol(true).mT(ModTags.Blocks.GROUND));
            if (i > 9) continue;
            entries.add(new FalloutEntry().prim(new Tuple.Pair<Object, Integer>(((Block)ModBlocks.SELLAFIELD_SLAKED.get()).defaultBlockState().setValue((Property)SellafieldSlakedBlock.COLOR_LEVEL, (Comparable)Integer.valueOf(m)), 1)).max(i * 5).sol(true).mBS(Blocks.GRASS_BLOCK.defaultBlockState()));
        }
        entries.add(new FalloutEntry().mBS(Blocks.MYCELIUM.defaultBlockState()).prim(new Tuple.Pair<BlockState, Integer>(((Block)ModBlocks.WASTE_MYCELIUM.get()).defaultBlockState(), 1)));
        entries.add(new FalloutEntry().mBS(Blocks.SAND.defaultBlockState()).prim(new Tuple.Pair<BlockState, Integer>(((Block)ModBlocks.WASTE_TRINITITE.get()).defaultBlockState(), 1)).c(0.05));
        entries.add(new FalloutEntry().mBS(Blocks.RED_SAND.defaultBlockState()).prim(new Tuple.Pair<BlockState, Integer>(((Block)ModBlocks.WASTE_TRINITITE_RED.get()).defaultBlockState(), 1)).c(0.05));
        entries.add(new FalloutEntry().mBS(Blocks.CLAY.defaultBlockState()).prim(new Tuple.Pair<BlockState, Integer>(Blocks.TERRACOTTA.defaultBlockState(), 1)));
    }

    private static void writeDefault(File file) {
        HBMsNTM.LOGGER.info("No fallout config file found, registering defaults for {}", (Object)file.getName());
        try {
            JsonWriter writer = new JsonWriter((Writer)new FileWriter(file));
            writer.setIndent("  ");
            writer.beginObject();
            writer.name("entries").beginArray();
            for (FalloutEntry entry : entries) {
                writer.beginObject();
                entry.write(writer);
                writer.endObject();
            }
            writer.endArray();
            writer.endObject();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static List<FalloutEntry> readConfig(File config) {
        try {
            JsonObject json = (JsonObject)gson.fromJson((Reader)new FileReader(config), JsonObject.class);
            JsonArray recipes = json.get("entries").getAsJsonArray();
            ArrayList<FalloutEntry> conf = new ArrayList<FalloutEntry>();
            for (JsonElement recipe : recipes) {
                conf.add(FalloutEntry.readEntry(recipe));
            }
            return conf;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static class FalloutEntry {
        private BlockState matchesBlockState = null;
        private TagKey<Block> matchesTag = null;
        private boolean matchesOpaque = false;
        private Tuple.Pair<BlockState, Integer>[] primaryBlocks = null;
        private Tuple.Pair<BlockState, Integer>[] secondaryBlocks = null;
        private double primaryChance = 1.0;
        private double minDist = 0.0;
        private double maxDist = 100.0;
        private double falloffStart = 0.9;
        private boolean isSolid = false;

        public FalloutEntry clone() {
            FalloutEntry entry = new FalloutEntry();
            entry.mBS(this.matchesBlockState);
            entry.mT(this.matchesTag);
            entry.mO(this.matchesOpaque);
            entry.prim(this.primaryBlocks);
            entry.sec(this.secondaryBlocks);
            entry.min(this.minDist);
            entry.max(this.maxDist);
            entry.fo(this.falloffStart);
            entry.sol(this.isSolid);
            return entry;
        }

        public FalloutEntry mBS(BlockState state) {
            this.matchesBlockState = state;
            return this;
        }

        public FalloutEntry mT(TagKey<Block> tag) {
            this.matchesTag = tag;
            return this;
        }

        public FalloutEntry mO(boolean opaque) {
            this.matchesOpaque = opaque;
            return this;
        }

        public FalloutEntry prim(Tuple.Pair<BlockState, Integer> ... blocks) {
            this.primaryBlocks = blocks;
            return this;
        }

        public FalloutEntry sec(Tuple.Pair<BlockState, Integer> ... blocks) {
            this.secondaryBlocks = blocks;
            return this;
        }

        public FalloutEntry c(double chance) {
            this.primaryChance = chance;
            return this;
        }

        public FalloutEntry min(double min) {
            this.minDist = min;
            return this;
        }

        public FalloutEntry max(double max) {
            this.maxDist = max;
            return this;
        }

        public FalloutEntry fo(double falloffStart) {
            this.falloffStart = falloffStart;
            return this;
        }

        public FalloutEntry sol(boolean solid) {
            this.isSolid = solid;
            return this;
        }

        public boolean eval(Level level, BlockPos pos, BlockState state, double dist) {
            if (dist > this.maxDist || dist < this.minDist) {
                return false;
            }
            if (this.matchesBlockState != null && state != this.matchesBlockState) {
                return false;
            }
            if (this.matchesTag != null && !state.is(this.matchesTag)) {
                return false;
            }
            if (this.matchesOpaque && !state.isSolidRender((BlockGetter)level, pos)) {
                return false;
            }
            if (dist > this.maxDist * this.falloffStart && Math.abs(level.random.nextGaussian()) < Math.pow((dist - this.maxDist * this.falloffStart) / (this.maxDist - this.maxDist * this.falloffStart), 2.0) * 3.0) {
                return false;
            }
            RecipesCommon.StateBlock conversion = this.chooseRandomOutcome(this.primaryChance == 1.0 || rand.nextDouble() < this.primaryChance ? this.primaryBlocks : this.secondaryBlocks);
            if (conversion != null) {
                if (conversion.state == ((Block)ModBlocks.SELLAFIELD_SLAKED.get()).defaultBlockState() && state == ((Block)ModBlocks.SELLAFIELD_SLAKED.get()).defaultBlockState()) {
                    return false;
                }
                if (conversion.state == ((Block)ModBlocks.SELLAFIELD_BEDROCK.get()).defaultBlockState() && state == ((Block)ModBlocks.SELLAFIELD_BEDROCK.get()).defaultBlockState()) {
                    return false;
                }
                if (state == ((Block)ModBlocks.SELLAFIELD_BEDROCK.get()).defaultBlockState() && conversion.state != ((Block)ModBlocks.SELLAFIELD_BEDROCK.get()).defaultBlockState()) {
                    return false;
                }
                if (pos.getY() == 0 && conversion.state != ((Block)ModBlocks.SELLAFIELD_BEDROCK.get()).defaultBlockState()) {
                    return false;
                }
                level.setBlock(pos, conversion.state, 3);
                return true;
            }
            return false;
        }

        private RecipesCommon.StateBlock chooseRandomOutcome(Tuple.Pair<BlockState, Integer>[] blocks) {
            if (blocks == null) {
                return null;
            }
            int weight = 0;
            for (Tuple.Pair<BlockState, Integer> choice : blocks) {
                weight += choice.getValue().intValue();
            }
            int r = rand.nextInt(weight);
            for (Tuple.Pair<BlockState, Integer> choice : blocks) {
                if ((r -= choice.getValue().intValue()) > 0) continue;
                return new RecipesCommon.StateBlock(choice.getKey());
            }
            return new RecipesCommon.StateBlock(blocks[0].getKey());
        }

        public boolean isSolid() {
            return this.isSolid;
        }

        public void write(JsonWriter writer) throws IOException {
            if (this.matchesBlockState != null) {
                writer.name("matchesBlockState").value(BuiltInRegistries.BLOCK.getKey((Object)this.matchesBlockState.getBlock()).toString());
            }
            if (this.matchesTag != null) {
                writer.name("matchesTag").value(this.matchesTag.location().toString());
            }
            if (this.matchesOpaque) {
                writer.name("mustBeOpaque").value(true);
            }
            if (this.isSolid) {
                writer.name("restrictDepth").value(true);
            }
            if (this.primaryBlocks != null) {
                writer.name("primarySubstitution");
                FalloutEntry.writeBlockStateArray(writer, this.primaryBlocks);
            }
            if (this.secondaryBlocks != null) {
                writer.name("secondarySubstitutions");
                FalloutEntry.writeBlockStateArray(writer, this.secondaryBlocks);
            }
            if (this.primaryChance != 1.0) {
                writer.name("chance").value(this.primaryChance);
            }
            if (this.minDist != 0.0) {
                writer.name("minimumDistancePercent").value(this.minDist);
            }
            if (this.maxDist != 100.0) {
                writer.name("maximumDistancePercent").value(this.maxDist);
            }
            if (this.falloffStart != 0.9) {
                writer.name("falloffStartFactor").value(this.falloffStart);
            }
        }

        private static FalloutEntry readEntry(JsonElement recipe) {
            FalloutEntry entry = new FalloutEntry();
            if (!recipe.isJsonObject()) {
                return null;
            }
            JsonObject obj = recipe.getAsJsonObject();
            if (obj.has("matchesBlock")) {
                entry.mBS(((Block)BuiltInRegistries.BLOCK.getOptional(ResourceLocation.parse((String)obj.get("matchesBlock").getAsString())).get()).defaultBlockState());
            }
            if (obj.has("matchesTag")) {
                entry.mT((TagKey<Block>)TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.parse((String)obj.get("matchesTag").getAsString())));
            }
            if (obj.has("mustBeOpaque")) {
                entry.mO(obj.get("mustBeOpaque").getAsBoolean());
            }
            if (obj.has("restrictDepth")) {
                entry.sol(obj.get("restrictDepth").getAsBoolean());
            }
            if (obj.has("primarySubstitution")) {
                entry.prim(FalloutEntry.readBlockStateArray(obj.get("primarySubstitution")));
            }
            if (obj.has("secondarySubstitutions")) {
                entry.sec(FalloutEntry.readBlockStateArray(obj.get("secondarySubstitutions")));
            }
            if (obj.has("chance")) {
                entry.c(obj.get("chance").getAsDouble());
            }
            if (obj.has("minimumDistancePercent")) {
                entry.min(obj.get("minimumDistancePercent").getAsDouble());
            }
            if (obj.has("maximumDistancePercent")) {
                entry.max(obj.get("maximumDistancePercent").getAsDouble());
            }
            if (obj.has("falloffStartFactor")) {
                entry.fo(obj.get("falloffStartFactor").getAsDouble());
            }
            return entry;
        }

        private static void writeBlockStateArray(JsonWriter writer, Tuple.Pair<BlockState, Integer>[] array) throws IOException {
            writer.beginArray();
            writer.setIndent("");
            for (Tuple.Pair<BlockState, Integer> blockState : array) {
                writer.beginArray();
                writer.value(String.valueOf(BuiltInRegistries.BLOCK.getKey((Object)blockState.getKey().getBlock())));
                writer.value((Number)blockState.getValue());
                writer.endArray();
            }
            writer.endArray();
            writer.setIndent("  ");
        }

        private static Tuple.Pair<BlockState, Integer>[] readBlockStateArray(JsonElement jsonElement) {
            if (!jsonElement.isJsonArray()) {
                return null;
            }
            JsonArray array = jsonElement.getAsJsonArray();
            Tuple.Pair[] blockStateArray = new Tuple.Pair[array.size()];
            for (int i = 0; i < blockStateArray.length; ++i) {
                JsonElement stateBlock = array.get(i);
                if (!stateBlock.isJsonArray()) {
                    throw new IllegalStateException("Could not read block " + String.valueOf(stateBlock));
                }
                JsonArray mBArray = stateBlock.getAsJsonArray();
                blockStateArray[i] = new Tuple.Pair<Object, Integer>(BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)mBArray.get(0).getAsString())), mBArray.get(1).getAsInt());
            }
            return blockStateArray;
        }
    }
}

