/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.effect;

import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.generic.FalloutBlock;
import com.hbm.config.FalloutConfigJSON;
import com.hbm.config.MainConfig;
import com.hbm.entity.logic.ChunkloadingEntity;
import com.hbm.world.WorldUtil;
import com.hbm.world.biome.ModBiomes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;

public class FalloutRain
extends ChunkloadingEntity {
    private boolean firstTick = true;
    private final Level level;
    private static final EntityDataAccessor<Integer> SCALE = SynchedEntityData.defineId(FalloutRain.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private final Map<ResourceKey<Biome>, Holder<Biome>> biomeCache = new HashMap<ResourceKey<Biome>, Holder<Biome>>();
    private int tickDelay;
    private int mk5;
    private final List<Long> chunksToProcess;
    private final List<Long> outerChunksToProcess;

    public FalloutRain(EntityType<?> type, Level level) {
        super(type, level);
        this.tickDelay = (Integer)MainConfig.COMMON.FALLOUT_DELAY.get();
        this.mk5 = (Integer)MainConfig.COMMON.MK5.get();
        this.chunksToProcess = new ArrayList<Long>();
        this.outerChunksToProcess = new ArrayList<Long>();
        this.level = level;
    }

    private Holder<Biome> getCachedHolder(ResourceKey<Biome> key) {
        return this.biomeCache.computeIfAbsent(key, k -> this.level.registryAccess().registryOrThrow(Registries.BIOME).getHolderOrThrow(k));
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            long start = System.currentTimeMillis();
            if (this.firstTick) {
                if (this.chunksToProcess.isEmpty() && this.outerChunksToProcess.isEmpty()) {
                    this.gatherChunks();
                }
                if (((Boolean)MainConfig.COMMON.ENABLE_CRATER_BIOMES.get()).booleanValue()) {
                    this.biomeCache.put(ModBiomes.CRATER_INNER, this.getCachedHolder(ModBiomes.CRATER_INNER));
                    this.biomeCache.put(ModBiomes.CRATER, this.getCachedHolder(ModBiomes.CRATER));
                    this.biomeCache.put(ModBiomes.CRATER_OUTER, this.getCachedHolder(ModBiomes.CRATER_OUTER));
                }
                this.firstTick = false;
            }
            if (this.tickDelay == 0) {
                this.tickDelay = (Integer)MainConfig.COMMON.FALLOUT_DELAY.get();
                while (System.currentTimeMillis() < start + (long)this.mk5) {
                    int z;
                    int x;
                    LevelChunk chunk;
                    int chunkPosZ;
                    int chunkPosX;
                    long chunkPos;
                    if (!this.chunksToProcess.isEmpty()) {
                        chunkPos = this.chunksToProcess.removeLast();
                        chunkPosX = ChunkPos.getX((long)chunkPos);
                        chunkPosZ = ChunkPos.getZ((long)chunkPos);
                        chunk = this.level.getChunk(chunkPosX, chunkPosZ);
                        for (x = chunkPosX << 4; x < (chunkPosX << 4) + 16; ++x) {
                            for (z = chunkPosZ << 4; z < (chunkPosZ << 4) + 16; ++z) {
                                Holder<Biome> biomeHolder;
                                double percent = Math.hypot((double)x - this.getX(), (double)z - this.getZ()) * 100.0 / (double)this.getScale();
                                this.stomp(x, z, percent);
                                ResourceKey<Biome> biomeKey = FalloutRain.getBiomeChange(percent, this.getScale(), (ResourceKey<Biome>)this.level.getBiome(new BlockPos(x, 64, z)).getKey());
                                if (biomeKey == null || (biomeHolder = this.biomeCache.get(biomeKey)) == null) continue;
                                WorldUtil.setBiomeColumn((ServerLevel)this.level, x, z, biomeHolder);
                            }
                        }
                        WorldUtil.flushChunk((ServerLevel)this.level, chunk);
                        continue;
                    }
                    if (!this.outerChunksToProcess.isEmpty()) {
                        chunkPos = this.outerChunksToProcess.removeLast();
                        chunkPosX = ChunkPos.getX((long)chunkPos);
                        chunkPosZ = ChunkPos.getZ((long)chunkPos);
                        chunk = this.level.getChunk(chunkPosX, chunkPosZ);
                        for (x = chunkPosX << 4; x < (chunkPosX << 4) + 16; ++x) {
                            for (z = chunkPosZ << 4; z < (chunkPosZ << 4) + 16; ++z) {
                                Holder<Biome> biomeHolder;
                                double distance = Math.hypot((double)x - this.getX(), (double)z - this.getZ());
                                if (!(distance <= (double)this.getScale())) continue;
                                double percent = distance * 100.0 / (double)this.getScale();
                                this.stomp(x, z, percent);
                                ResourceKey<Biome> biomeKey = FalloutRain.getBiomeChange(percent, this.getScale(), (ResourceKey<Biome>)this.level.getBiome(new BlockPos(x, 64, z)).getKey());
                                if (biomeKey == null || (biomeHolder = this.biomeCache.get(biomeKey)) == null) continue;
                                WorldUtil.setBiomeColumn((ServerLevel)this.level, x, z, biomeHolder);
                            }
                        }
                        WorldUtil.flushChunk((ServerLevel)this.level, chunk);
                        continue;
                    }
                    this.discard();
                }
            }
            --this.tickDelay;
        }
    }

    public static ResourceKey<Biome> getBiomeChange(double dist, int scale, ResourceKey<Biome> original) {
        if (!((Boolean)MainConfig.COMMON.ENABLE_CRATER_BIOMES.get()).booleanValue()) {
            return null;
        }
        if (scale >= 150 && dist < 15.0) {
            return ModBiomes.CRATER_INNER;
        }
        if (scale >= 100 && dist < 55.0 && original != ModBiomes.CRATER_INNER) {
            return ModBiomes.CRATER;
        }
        if (scale >= 25 && original != ModBiomes.CRATER_INNER && original != ModBiomes.CRATER) {
            return ModBiomes.CRATER_OUTER;
        }
        return null;
    }

    private void gatherChunks() {
        LinkedHashSet<Long> chunks = new LinkedHashSet<Long>();
        LinkedHashSet<Long> outerChunks = new LinkedHashSet<Long>();
        int outerRange = this.getScale();
        int adjustedMaxAngle = 20 * outerRange / 32;
        for (int angle = 0; angle <= adjustedMaxAngle; ++angle) {
            Vec3 vector = new Vec3((double)outerRange, 0.0, 0.0).yRot((float)((double)angle * Math.PI / 180.0 / ((double)adjustedMaxAngle / 360.0)));
            outerChunks.add(ChunkPos.asLong((int)((int)(this.getX() + vector.x) >> 4), (int)((int)(this.getZ() + vector.z) >> 4)));
        }
        for (int distance = 0; distance <= outerRange; distance += 8) {
            for (int angle = 0; angle <= adjustedMaxAngle; ++angle) {
                Vec3 vector = new Vec3((double)distance, 0.0, 0.0).yRot((float)((double)angle * Math.PI / 180.0 / ((double)adjustedMaxAngle / 360.0)));
                long chunkCoord = ChunkPos.asLong((int)((int)(this.getX() + vector.x) >> 4), (int)((int)(this.getZ() + vector.z) >> 4));
                if (outerChunks.contains(chunkCoord)) continue;
                chunks.add(chunkCoord);
            }
        }
        this.chunksToProcess.addAll(chunks);
        this.outerChunksToProcess.addAll(outerChunks);
        Collections.reverse(this.chunksToProcess);
        Collections.reverse(this.outerChunksToProcess);
    }

    private void stomp(int x, int z, double dist) {
        int depth = 0;
        for (int y = 320; y >= -64; --y) {
            double d;
            double chance;
            if (depth >= 3) {
                return;
            }
            BlockPos pos = new BlockPos(x, y, z);
            BlockState state = this.level.getBlockState(pos);
            if (state.isAir() || state.is((Block)ModBlocks.FALLOUT.get())) continue;
            BlockPos above = pos.above();
            BlockState aboveState = this.level.getBlockState(above);
            if (depth == 0 && !state.is((Block)ModBlocks.FALLOUT.get()) && (aboveState.isAir() || aboveState.canBeReplaced() && !aboveState.getFluidState().isEmpty()) && (chance = 0.1 - Math.pow((d = dist / 100.0) - 0.7, 2.0)) >= this.random.nextDouble() && FalloutBlock.canPlaceBlockAt(this.level, above)) {
                this.level.setBlock(above, ((Block)ModBlocks.FALLOUT.get()).defaultBlockState(), 3);
            }
            if (dist < 65.0 && state.isFlammable((BlockGetter)this.level, pos, Direction.UP) && this.random.nextInt(5) == 0 && this.level.getBlockState(above).isAir()) {
                this.level.setBlock(above, Blocks.FIRE.defaultBlockState(), 3);
            }
            boolean eval = false;
            for (FalloutConfigJSON.FalloutEntry entry : FalloutConfigJSON.entries) {
                if (!entry.eval(this.level, pos, state, dist)) continue;
                if (entry.isSolid()) {
                    ++depth;
                }
                eval = true;
                break;
            }
            if (eval || !state.isSolidRender((BlockGetter)this.level, pos)) continue;
            ++depth;
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(SCALE, (Object)1);
    }

    protected void readAdditionalSaveData(CompoundTag compoundTag) {
        this.setScale(compoundTag.getInt("scale"));
        this.chunksToProcess.addAll(this.readChunksFromIntArray(compoundTag.getIntArray("chunks")));
        this.outerChunksToProcess.addAll(this.readChunksFromIntArray(compoundTag.getIntArray("outerChunks")));
    }

    private Collection<Long> readChunksFromIntArray(int[] data) {
        ArrayList<Long> coords = new ArrayList<Long>();
        for (int i = 0; i < data.length; i += 2) {
            int x = data[i];
            int z = data[i + 1];
            coords.add(ChunkPos.asLong((int)x, (int)z));
        }
        return coords;
    }

    protected void addAdditionalSaveData(CompoundTag compoundTag) {
        compoundTag.putInt("scale", this.getScale());
        compoundTag.putIntArray("chunks", this.writeChunksToIntArray(this.chunksToProcess));
        compoundTag.putIntArray("outerChunks", this.writeChunksToIntArray(this.outerChunksToProcess));
    }

    private int[] writeChunksToIntArray(Collection<Long> coords) {
        int[] data = new int[coords.size() * 2];
        int i = 0;
        for (long packed : coords) {
            data[i++] = ChunkPos.getX((long)packed);
            data[i++] = ChunkPos.getZ((long)packed);
        }
        return data;
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        return true;
    }

    public void setScale(int i) {
        this.entityData.set(SCALE, (Object)i);
    }

    public int getScale() {
        int scale = (Integer)this.entityData.get(SCALE);
        return scale == 0 ? 1 : scale;
    }
}

