/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.logic;

import com.hbm.HBMsNTM;
import com.hbm.config.MainConfig;
import com.hbm.entity.ModEntities;
import com.hbm.entity.effect.FalloutRain;
import com.hbm.entity.logic.ChunkloadingEntity;
import com.hbm.explosion.ExplosionNukeGeneric;
import com.hbm.explosion.ExplosionNukeRayBatched;
import com.hbm.interfaces.IExplosionRay;
import com.hbm.util.ContaminationUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class NukeExplosionMK5
extends ChunkloadingEntity {
    public int strength;
    public int speed;
    public int length;
    private long explosionStart;
    public boolean fallout = true;
    private int falloutAdd = 0;
    private IExplosionRay explosion;

    public NukeExplosionMK5(EntityType<?> type, Level level) {
        super(type, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void tick() {
        super.tick();
        if (this.strength == 0) {
            this.discard();
        }
        if (!this.level().isClientSide) {
            this.updateChunkTicket();
        }
        if (!this.level().isClientSide && this.fallout && this.explosion != null && this.tickCount < 10 && this.strength >= 75) {
            this.radiate(2500000.0f / (float)(this.tickCount * 5 + 1), this.length * 2);
        }
        ExplosionNukeGeneric.dealDamage(this.level(), this.getX(), this.getY(), this.getZ(), this.length * 2);
        if (this.explosion == null) {
            this.explosionStart = System.currentTimeMillis();
            this.explosion = new ExplosionNukeRayBatched(this.level(), (int)this.getX(), (int)this.getY(), (int)this.getZ(), this.strength, this.speed, this.length);
        }
        if (!this.explosion.isComplete()) {
            this.explosion.cacheChunksTick((Integer)MainConfig.COMMON.MK5.get());
            this.explosion.destructionTick((Integer)MainConfig.COMMON.MK5.get());
        } else {
            if (((Boolean)MainConfig.COMMON.ENABLE_EXTENDED_LOGGING.get()).booleanValue() && this.explosionStart != 0L) {
                HBMsNTM.LOGGER.info("[NUKE] Explosion complete. Time elapsed: {}ms", (Object)(System.currentTimeMillis() - this.explosionStart));
            }
            if (this.fallout) {
                FalloutRain fallout = new FalloutRain((EntityType)ModEntities.NUKE_FALLOUT_RAIN.get(), this.level());
                fallout.setPos(this.getX(), this.getY(), this.getZ());
                fallout.setScale((int)((double)this.length * 2.5 + (double)this.falloutAdd) * (Integer)MainConfig.COMMON.FALLOUT_RANGE.get() / 100);
                this.level().addFreshEntity((Entity)fallout);
            }
            this.discard();
        }
    }

    private void radiate(float rads, double range) {
        AABB box = new AABB(this.getX(), this.getY(), this.getZ(), this.getX(), this.getY(), this.getZ()).inflate(range);
        List entities = this.level().getEntitiesOfClass(LivingEntity.class, box);
        for (LivingEntity e : entities) {
            Vec3 vec = new Vec3(e.getX() - this.getX(), e.getEyeY() - this.getY(), e.getZ() - this.getZ());
            double len = vec.length();
            vec = vec.normalize();
            float res = 0.0f;
            int i = 1;
            while ((double)i < len) {
                BlockPos pos = new BlockPos((int)Math.floor(this.getX() + vec.x * (double)i), (int)Math.floor(this.getY() + vec.y * (double)i), (int)Math.floor(this.getZ() + vec.z * (double)i));
                BlockState state = this.level().getBlockState(pos);
                res += state.getExplosionResistance((BlockGetter)this.level(), pos, null);
                ++i;
            }
            if (res < 1.0f) {
                res = 1.0f;
            }
            float eRads = rads;
            eRads /= res;
            ContaminationUtil.contaminate(e, ContaminationUtil.HazardType.RADIATION, ContaminationUtil.ContaminationType.RAD_BYPASS, eRads /= (float)(len * len));
        }
    }

    public void remove(Entity.RemovalReason reason) {
        if (this.explosion != null) {
            this.explosion.cancel();
        }
        super.remove(reason);
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        this.tickCount = tag.getInt("tickCount");
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        tag.putInt("tickCount", this.tickCount);
    }

    public static NukeExplosionMK5 statFac(Level level, int strength, double x, double y, double z) {
        if (((Boolean)MainConfig.COMMON.ENABLE_EXTENDED_LOGGING.get()).booleanValue() && !level.isClientSide) {
            HBMsNTM.LOGGER.info("[NUKE] Initialized explosion at {} / {} / {} with strength {}!", new Object[]{x, y, z, strength});
        }
        if (strength == 0) {
            strength = 25;
        }
        NukeExplosionMK5 explosionMK5 = new NukeExplosionMK5((EntityType)ModEntities.NUKE_MK5.get(), level);
        explosionMK5.strength = strength *= 2;
        explosionMK5.speed = (int)Math.ceil(100000.0 / (double)explosionMK5.strength);
        explosionMK5.setPos(x, y, z);
        explosionMK5.length = explosionMK5.strength / 2;
        level.addFreshEntity((Entity)explosionMK5);
        return explosionMK5;
    }

    public NukeExplosionMK5 setNoRad() {
        this.fallout = false;
        return this;
    }

    public NukeExplosionMK5 setMoreFallout(int toAdd) {
        this.falloutAdd = toAdd;
        return this;
    }
}

