/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.missile;

import api.hbm.entity.IRadarDetectableNT;
import com.hbm.HBMsNTMClient;
import com.hbm.entity.projectile.ThrowableInterp;
import com.hbm.explosion.ExplosionLarge;
import com.hbm.explosion.vanillant.ExplosionVNT;
import com.hbm.explosion.vanillant.standard.BlockAllocatorStandard;
import com.hbm.explosion.vanillant.standard.BlockMutatorFire;
import com.hbm.explosion.vanillant.standard.BlockProcessorStandard;
import com.hbm.explosion.vanillant.standard.EntityProcessorCross;
import com.hbm.explosion.vanillant.standard.PlayerProcessorStandard;
import com.hbm.util.Vec3NT;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public abstract class MissileBaseNT
extends ThrowableInterp
implements IRadarDetectableNT {
    private static final TicketType<UUID> CHUNK_TICKET = TicketType.create((String)"chunkloading_missle", Comparator.comparing(UUID::toString));
    private ChunkPos loadedChunk;
    public int startX = (int)this.getX();
    public int startZ = (int)this.getZ();
    public int targetX = (int)this.getX();
    public int targetZ = (int)this.getZ();
    public double velocity;
    public double decelY;
    public double accelXZ;
    public boolean isCluster = false;
    public int health = 50;

    public MissileBaseNT(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public MissileBaseNT(EntityType<?> entityType, Level level, float x, float y, float z, int a, int b) {
        this(entityType, level);
        this.moveTo(x, y, z, 0.0f, 0.0f);
        this.startX = (int)this.getX();
        this.startZ = (int)this.getZ();
        this.targetX = a;
        this.targetZ = b;
        this.setDeltaMovement(this.getDeltaMovement().add(0.0, 2.0, 0.0));
        Vec3 vector = new Vec3((double)(this.targetX - this.startX), 0.0, (double)(this.targetZ - this.startZ));
        this.accelXZ = this.decelY = 1.0 / vector.length();
        this.decelY *= 2.0;
        this.velocity = 0.0;
        this.setYRot((float)(Math.atan2((double)this.targetX - this.getX(), (double)this.targetZ - this.getZ()) * 180.0 / Math.PI));
    }

    public abstract ItemStack getMissileItemForInfo();

    @Override
    public void tick() {
        this.xo = this.getX();
        this.yo = this.getY();
        this.zo = this.getZ();
        super.tick();
        if (this.velocity < 4.0) {
            this.velocity += Mth.clamp((double)((double)this.tickCount / 60.0 * 0.05), (double)0.0, (double)0.05);
        }
        if (!this.level().isClientSide) {
            Vec3 motion;
            if (this.hasPropulsion()) {
                motion = this.getDeltaMovement();
                motion = motion.add(0.0, -this.decelY * this.velocity, 0.0);
                Vec3 vector = new Vec3((double)(this.targetX - this.startX), 0.0, (double)(this.targetZ - this.startZ)).normalize();
                vector = new Vec3(vector.x * this.accelXZ, 0.0, vector.z * this.accelXZ);
                if (motion.y > 0.0) {
                    motion = motion.add(vector.x * this.velocity, 0.0, vector.z * this.velocity);
                }
                if (motion.y < 0.0) {
                    motion = motion.add(-vector.x * this.velocity, 0.0, -vector.z * this.velocity);
                }
                this.setDeltaMovement(motion);
            } else {
                motion = this.getDeltaMovement();
                motion = new Vec3(motion.x * 0.99, motion.y, motion.z * 0.99);
                if (motion.y > -1.5) {
                    motion = motion.add(0.0, -0.05, 0.0);
                }
                this.setDeltaMovement(motion);
            }
            if (this.getDeltaMovement().y < -this.velocity && this.isCluster) {
                this.cluster();
                this.discard();
                return;
            }
            this.setYRot((float)(Math.atan2((double)this.targetX - this.getX(), (double)this.targetZ - this.getZ()) * 180.0 / Math.PI));
            motion = this.getDeltaMovement();
            float f2 = (float)Math.sqrt(motion.x * motion.x + motion.z * motion.z);
            this.setXRot((float)(Math.atan2(motion.y, f2) * 180.0 / Math.PI) - 90.0f);
            while (this.getXRot() - this.xRotO < -180.0f) {
                this.xRotO -= 360.0f;
            }
        } else {
            this.spawnContrail();
        }
        while (this.getXRot() - this.xRotO >= 180.0f) {
            this.xRotO += 360.0f;
        }
        while (this.getYRot() - this.yRotO < -180.0f) {
            this.yRotO -= 360.0f;
        }
        while (this.getYRot() - this.yRotO >= 180.0f) {
            this.yRotO += 360.0f;
        }
    }

    public boolean hasPropulsion() {
        return true;
    }

    protected void spawnContrail() {
        this.spawnContraolWithOffset(0.0, 0.0, 0.0);
    }

    protected void spawnContraolWithOffset(double offsetX, double offsetY, double offsetZ) {
        Vec3 vec = new Vec3(this.xo - this.getX(), this.yo - this.getY(), this.zo - this.getZ());
        double len = vec.length();
        vec = vec.normalize();
        Vec3NT thrust = new Vec3NT(0.0, 1.0, 0.0);
        thrust.rotateAroundXRad(this.getXRot() * (float)Math.PI / 180.0f);
        thrust.rotateAroundYRad((this.getYRot() + 90.0f) * (float)Math.PI / 180.0f);
        int i = 0;
        while ((double)i < Math.max(Math.min(len, 10.0), 1.0)) {
            double j = (double)i - len;
            CompoundTag tag = new CompoundTag();
            tag.putDouble("posX", this.getX() - vec.x * j + offsetX);
            tag.putDouble("posY", this.getY() - vec.y * j + offsetY);
            tag.putDouble("posZ", this.getZ() - vec.z * j + offsetZ);
            tag.putString("type", "missileContrail");
            tag.putFloat("scale", this.getContrailScale());
            tag.putDouble("moX", -thrust.xCoord);
            tag.putDouble("moY", -thrust.yCoord);
            tag.putDouble("moZ", -thrust.zCoord);
            tag.putInt("maxAge", 60 + this.random.nextInt(20));
            HBMsNTMClient.effectNT(tag);
            ++i;
        }
    }

    protected float getContrailScale() {
        return 1.0f;
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    @Override
    protected double motionMult() {
        return this.velocity;
    }

    @Override
    public boolean doesImpactEntities() {
        return false;
    }

    protected void killMissile() {
        if (this.isAlive()) {
            this.discard();
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                ExplosionLarge.explode(serverLevel, this.getX(), this.getY(), this.getZ(), 5, true, false, true);
                ExplosionLarge.spawnShrapnelShower(serverLevel, this.getX(), this.getY(), this.getZ(), this.getDeltaMovement().x, this.getDeltaMovement().y, this.getDeltaMovement().z, 15, 0.075);
                ExplosionLarge.spawnMissileDebris(serverLevel, this.getX(), this.getY(), this.getZ(), this.getDeltaMovement().x, this.getDeltaMovement().y, this.getDeltaMovement().z, 0.25, this.getDebris(), this.getDebrisRareDrop());
            }
        }
    }

    @Override
    protected void onImpact(HitResult hitResult) {
        if (hitResult != null && hitResult.getType() == HitResult.Type.BLOCK) {
            this.onMissileImpact(hitResult);
            this.discard();
        }
    }

    public abstract void onMissileImpact(HitResult var1);

    public abstract List<ItemStack> getDebris();

    public abstract ItemStack getDebrisRareDrop();

    public void cluster() {
    }

    @Override
    public double getGravityVelocity() {
        return 0.0;
    }

    @Override
    protected float getAirDrag() {
        return 1.0f;
    }

    @Override
    protected float getWaterDrag() {
        return 1.0f;
    }

    public void onAddedToLevel() {
        Level level;
        super.onAddedToLevel();
        if (!this.level().isClientSide && (level = this.level()) instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            this.loadedChunk = new ChunkPos(this.blockPosition());
            server.getChunkSource().addRegionTicket(CHUNK_TICKET, this.loadedChunk, 2, (Object)this.getUUID());
        }
    }

    public void onRemovedFromLevel() {
        Level level;
        super.onRemovedFromLevel();
        if (!this.level().isClientSide && this.loadedChunk != null && (level = this.level()) instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            server.getChunkSource().removeRegionTicket(CHUNK_TICKET, this.loadedChunk, 2, (Object)this.getUUID());
            this.loadedChunk = null;
        }
    }

    public void explodeStandard(float strength, int resolution, boolean fire) {
        ExplosionVNT vnt = new ExplosionVNT(this.level(), this.getX(), this.getY(), this.getZ(), strength).setBlockAllocator(new BlockAllocatorStandard(resolution)).setBlockProcessor(new BlockProcessorStandard().setNoDrop().withBlockEffect(fire ? new BlockMutatorFire() : null)).setEntityProcessor(new EntityProcessorCross(7.5).withRangeMod(2.0f)).setPlayerProcessor(new PlayerProcessorStandard());
        vnt.explode();
    }

    @Override
    public String getUnlocalizedName() {
        return "Unknown";
    }

    @Override
    public int getBlipLevel() {
        return 13;
    }

    @Override
    public boolean canBeSeenBy(Object radar) {
        return true;
    }

    @Override
    public boolean paramsApplicable(IRadarDetectableNT.RadarScanParams params) {
        return params.scanMissiles;
    }

    @Override
    public boolean suppliesRedstone(IRadarDetectableNT.RadarScanParams params) {
        return !params.smartMode || !(this.getDeltaMovement().y >= 0.0);
    }
}

