/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.missile;

import com.hbm.entity.missile.MissileBaseNT;
import com.hbm.items.ModItems;
import com.hbm.particle.helper.ExplosionCreator;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;

public abstract class MissileTier1
extends MissileBaseNT {
    public MissileTier1(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public MissileTier1(EntityType<?> entityType, Level level, float x, float y, float z, int a, int b) {
        super(entityType, level, x, y, z, a, b);
    }

    @Override
    public List<ItemStack> getDebris() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(new ItemStack((ItemLike)ModItems.NOTHING.get(), 4));
        return list;
    }

    @Override
    protected float getContrailScale() {
        return 0.5f;
    }

    public static class MissileGeneric
    extends MissileTier1 {
        public MissileGeneric(EntityType<?> entityType, Level level) {
            super(entityType, level);
        }

        public MissileGeneric(EntityType<?> entityType, Level level, float x, float y, float z, int a, int b) {
            super(entityType, level, x, y, z, a, b);
        }

        @Override
        public void onMissileImpact(HitResult mop) {
            this.explodeStandard(15.0f, 24, false);
            ExplosionCreator.composeEffectSmall(this.level(), this.getX(), this.getY(), this.getZ());
        }

        @Override
        public ItemStack getDebrisRareDrop() {
            return new ItemStack((ItemLike)ModItems.NOTHING.get());
        }

        @Override
        public ItemStack getMissileItemForInfo() {
            return new ItemStack((ItemLike)ModItems.NOTHING.get());
        }
    }
}

